---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-入力マッピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/input/input_map.h` - InputMapシングルトン、Action構造体、API定義（40-117行目）
- E-02: `core/input/input_map.cpp` - アクション管理実装（40-200行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.26の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.21、36との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputMapシングルトン | E-01 (60行目: static inline InputMap *singleton) | ○ |
| C-02 | Action構造体でid、deadzone、inputsを管理 | E-01 (49-53行目) | ○ |
| C-03 | DEFAULT_DEADZONE = 0.2 | E-01 (55行目) | ○ |
| C-04 | DEFAULT_TOGGLE_DEADZONE = 0.5 | E-01 (57行目) | ○ |
| C-05 | ALL_DEVICES = -1 | E-01 (47行目) | ○ |
| C-06 | add_action API | E-01 (83行目)、E-02 (115-122行目) | ○ |
| C-07 | erase_action API | E-01 (84行目)、E-02 (124-128行目) | ○ |
| C-08 | action_add_event API | E-01 (90行目)、E-02 (199行目〜) | ○ |
| C-09 | action_has_event API | E-01 (91行目) | ○ |
| C-10 | event_is_action API | E-01 (96行目) | ○ |
| C-11 | _find_event内部関数でイベント検索 | E-01 (66行目)、E-02 (144-162行目) | ○ |
| C-12 | suggest_actions関数で類似アクション提案 | E-02 (63-84行目) | ○ |
| C-13 | load_from_project_settings API | E-01 (101行目) | ○ |
| C-14 | load_default API | E-01 (102行目) | ○ |
| C-15 | 画面No.21（プロジェクト設定）が主機能画面 | E-04 | ○ |
| C-16 | 画面No.36（入力イベント設定ダイアログ）が主機能画面 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目に十分な根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: Action構造体の定義 - 低リスク
- 0: API定義（メソッドシグネチャ） - 低リスク
- 0: デッドゾーン定数値 - 低リスク
- 0: 画面マッピング - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Action構造体のメンバ変数が正確に記載されているか確認
- [ ] DEFAULT_DEADZONE、DEFAULT_TOGGLE_DEADZONEの値を確認
- [ ] _find_eventの検索ロジックを確認
- [ ] suggest_actionsの類似度計算を確認
