---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-UIコントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **queue_sortによるレイアウト遅延実行の詳細**：バッチ処理の仕組み確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/gui/control.h` - Controlクラス定義、enum定義（44-199行目）
- E-02: `scene/gui/control.cpp` - Control実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.27の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.9との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ControlはCanvasItemを継承 | E-01 (44行目: GDCLASS(Control, CanvasItem)) | ○ |
| C-02 | Anchor enum（ANCHOR_BEGIN = 0、ANCHOR_END = 1） | E-01 (54-58行目) | ○ |
| C-03 | GrowDirection enum（BEGIN/END/BOTH） | E-01 (59-63行目) | ○ |
| C-04 | FocusMode enum（NONE/CLICK/ALL/ACCESSIBILITY） | E-01 (65-70行目) | ○ |
| C-05 | SizeFlags enum（SHRINK_BEGIN/FILL/EXPAND/SHRINK_CENTER/SHRINK_END） | E-01 (78-86行目) | ○ |
| C-06 | MouseFilter enum（STOP/PASS/IGNORE） | E-01 (88-92行目) | ○ |
| C-07 | LayoutPreset enum（TOP_LEFT〜FULL_RECT） | E-01 (121-138行目) | ○ |
| C-08 | LayoutDirection enum（INHERITED/LTR/RTL等） | E-01 (154-164行目) | ○ |
| C-09 | CursorShape enum（ARROW〜HELP） | E-01 (100-118行目) | ○ |
| C-10 | get_minimum_size、get_combined_minimum_size API | E-01（メソッド宣言） | ○ |
| C-11 | _gui_input仮想メソッドで入力処理 | E-01（GDVIRTUAL宣言） | ○ |
| C-12 | テーマキャッシュ（_update_theme_item_cache） | E-01 (134行目) | ○ |
| C-13 | RTLサポート（is_layout_rtl） | E-01 | ○ |
| C-14 | 画面No.9（インスペクタードック）が補助機能画面 | E-04 | ○ |
| C-15 | queue_sortによるレイアウト遅延実行 | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- **queue_sortの詳細実装**：Control.cppまたはContainer.cppでの実装確認が必要
  - 候補：scene/gui/container.cpp

## 5) リスクフラグ（レビュー観点）
- 0: enum定義 - 低リスク
- 0: クラス継承関係 - 低リスク
- 1: レイアウト遅延実行 - 中リスク（詳細確認必要）
- 0: 画面マッピング - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] enum定義（Anchor、SizeFlags等）が正確か確認
- [ ] ControlがCanvasItemを継承しているか確認
- [ ] _gui_input、_notification等の仮想メソッドを確認
- [ ] queue_sortの動作をContainer.cppで確認
