---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-コンテナレイアウト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/gui/container.h` - Container基底クラス定義（35-76行目）
- E-02: `scene/gui/container.cpp` - Container実装（81-234行目）
- E-03: `scene/gui/box_container.h` - BoxContainer、AlignmentMode定義（35-98行目）
- E-04: `scene/gui/box_container.cpp` - BoxContainer実装（43-399行目）
- E-05: `scene/gui/grid_container.h` - GridContainer定義（35-55行目）
- E-06: `scene/gui/grid_container.cpp` - GridContainer実装（36-320行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.28の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ContainerはControlを継承 | E-01 (35行目: GDCLASS(Container, Control)) | ○ |
| C-02 | NOTIFICATION_PRE_SORT_CHILDREN = 50 | E-01 (64行目) | ○ |
| C-03 | NOTIFICATION_SORT_CHILDREN = 51 | E-01 (65行目) | ○ |
| C-04 | pending_sortフラグで重複ソート防止 | E-01 (38行目)、E-02 (135-137行目) | ○ |
| C-05 | queue_sortでcall_deferred | E-02 (139行目) | ○ |
| C-06 | _sort_childrenで通知とシグナル発行 | E-02 (87-91行目) | ○ |
| C-07 | fit_child_in_rectでサイズフラグ判定 | E-02 (103-123行目) | ○ |
| C-08 | SortableVisibilityMode enum（VISIBLE/VISIBLE_IN_TREE/IGNORE） | E-01 (43-47行目) | ○ |
| C-09 | BoxContainer::AlignmentMode（BEGIN/CENTER/END） | E-03 (39-43行目) | ○ |
| C-10 | BoxContainer._resortで伸縮計算 | E-04 (43-236行目) | ○ |
| C-11 | stretch_ratio_totalに基づく余白分配 | E-04 (119行目) | ○ |
| C-12 | エラー蓄積による端数補正 | E-04 (120-137行目) | ○ |
| C-13 | HBoxContainer/VBoxContainerはBoxContainerを継承 | E-03 (79-96行目) | ○ |
| C-14 | GridContainer.columnsはデフォルト1 | E-05 (38行目) | ○ |
| C-15 | GridContainer.h_separation、v_separationのThemeCache | E-05 (40-43行目) | ○ |
| C-16 | GridContainerの行列計算（row/col） | E-06 (52-53行目、190-191行目) | ○ |
| C-17 | アクセシビリティロール：ROLE_CONTAINER | E-02 (191行目) | ○ |
| C-18 | add_spacerメソッドでスペーサー追加 | E-04 (322-338行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目に十分な根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: Container基底クラスの通知定数 - 低リスク
- 0: queue_sortの遅延実行 - 低リスク
- 0: BoxContainerの伸縮計算 - 低リスク
- 0: GridContainerの行列配置 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_PRE_SORT_CHILDREN/SORT_CHILDRENの値を確認
- [ ] queue_sortの遅延実行ロジックを確認
- [ ] fit_child_in_rectのサイズフラグ処理を確認
- [ ] BoxContainer._resortの伸縮計算ロジックを確認
