---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-テーマシステム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/resources/theme.h` - Themeクラス定義、DataType enum、HashMap定義（38-238行目）
- E-02: `scene/resources/theme.cpp` - Theme実装（36-300行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.29の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThemeはResourceを継承 | E-01 (38行目: GDCLASS(Theme, Resource)) | ○ |
| C-02 | RES_BASE_EXTENSION("theme") | E-01 (40行目) | ○ |
| C-03 | DataType enum（COLOR=0〜STYLEBOX=5、DATA_TYPE_MAX=6） | E-01 (56-64行目) | ○ |
| C-04 | icon_map: HashMap<StringName, ThemeIconMap> | E-01 (100行目) | ○ |
| C-05 | style_map: HashMap<StringName, ThemeStyleMap> | E-01 (101行目) | ○ |
| C-06 | font_map: HashMap<StringName, ThemeFontMap> | E-01 (102行目) | ○ |
| C-07 | font_size_map: HashMap<StringName, ThemeFontSizeMap> | E-01 (103行目) | ○ |
| C-08 | color_map: HashMap<StringName, ThemeColorMap> | E-01 (104行目) | ○ |
| C-09 | constant_map: HashMap<StringName, ThemeConstantMap> | E-01 (105行目) | ○ |
| C-10 | variation_map: HashMap<StringName, StringName> | E-01 (106行目) | ○ |
| C-11 | variation_base_map: HashMap<StringName, List<StringName>> | E-01 (107行目) | ○ |
| C-12 | default_base_scale、default_font、default_font_size | E-01 (96-98行目) | ○ |
| C-13 | is_valid_item_name: 英数字とアンダースコア判定 | E-02 (189-201行目) | ○ |
| C-14 | is_valid_type_name: 英数字とアンダースコア判定 | E-02 (178-187行目) | ○ |
| C-15 | set_iconでconnect_changed設定 | E-02 (292行目) | ○ |
| C-16 | _emit_theme_changedで変更通知 | E-01 (69行目)、E-02 (295行目) | ○ |
| C-17 | merge_with、clear APIの存在 | E-01 (231-232行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目に十分な根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: DataType enumの定義 - 低リスク
- 0: HashMap構造の定義 - 低リスク
- 0: 名前検証ロジック - 低リスク
- 0: テーマ変更通知 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] DataType enumの値（COLOR=0〜STYLEBOX=5）を確認
- [ ] icon_map等のHashMap構造を確認
- [ ] is_valid_item_name/is_valid_type_nameの検証ロジックを確認
- [ ] set_icon等でのconnect_changed設定を確認
- [ ] variation_map/variation_base_mapの継承関係を確認
