---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-リッチテキスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/gui/rich_text_label.h` - RichTextLabelクラス定義、Item構造体、enum定義（47-1040行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.30の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RichTextLabelはControlを継承 | E-01 (47行目: GDCLASS(RichTextLabel, Control)) | ○ |
| C-02 | ListType enum（NUMBERS/LETTERS/ROMAN/DOTS） | E-01 (61-66行目) | ○ |
| C-03 | MetaUnderline enum（NEVER/ALWAYS/ON_HOVER） | E-01 (68-72行目) | ○ |
| C-04 | ItemType enum（ITEM_FRAME〜ITEM_CONTEXT） | E-01 (74-105行目) | ○ |
| C-05 | MenuItems enum（MENU_COPY/SELECT_ALL/MAX） | E-01 (107-111行目) | ○ |
| C-06 | DefaultFont enum（NORMAL/BOLD/ITALICS等） | E-01 (113-120行目) | ○ |
| C-07 | ImageUpdateMask bitfield定義 | E-01 (122-131行目) | ○ |
| C-08 | Item基底構造体（index, char_ofs, parent, type等） | E-01 (200-226行目) | ○ |
| C-09 | ItemFrame構造体（cell, lines, parent_frame等） | E-01 (228-252行目) | ○ |
| C-10 | ItemText構造体（text: String） | E-01 (254-257行目) | ○ |
| C-11 | ItemImage構造体（image, inline_align, region, size等） | E-01 (278-303行目) | ○ |
| C-12 | ItemShake構造体（strength, rate, _current_rng等） | E-01 (434-457行目) | ○ |
| C-13 | ItemWave構造体（frequency, amplitude） | E-01 (459-465行目) | ○ |
| C-14 | ItemTornado構造体（radius, frequency） | E-01 (467-473行目) | ○ |
| C-15 | ItemRainbow構造体（saturation, value, frequency, speed） | E-01 (475-482行目) | ○ |
| C-16 | ItemPulse構造体（color, frequency, ease） | E-01 (484-490行目) | ○ |
| C-17 | threaded、stop_thread、updating等のatomic変数 | E-01 (544-548行目) | ○ |
| C-18 | progress_delay = 1000（デフォルト） | E-01 (552行目) | ○ |
| C-19 | ThemeCache構造体（normal_style, normal_font, default_color等） | E-01 (771-818行目) | ○ |
| C-20 | visible_characters、visible_ratio | E-01 (659-661行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目に十分な根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: ItemType enumの定義 - 低リスク
- 0: Item構造体の定義 - 低リスク
- 0: エフェクト構造体（Shake/Wave/Tornado等） - 低リスク
- 0: スレッド処理関連変数 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ItemType enumの全項目を確認
- [ ] Item基底構造体のメンバを確認
- [ ] エフェクト構造体（ItemShake, ItemWave等）のパラメータを確認
- [ ] threaded処理のatomic変数使用を確認
- [ ] ThemeCacheのスタイル項目を確認
