---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 31-AnimationPlayer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **関連画面の正確性**：エディタパネル名の確認が必要
  2. **パフォーマンス記述**：増分更新の詳細実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/animation/animation_player.h` - AnimationPlayerクラス定義
- E-02: `scene/animation/animation_player.cpp` - AnimationPlayer実装
- E-03: `scene/animation/animation_mixer.h` - AnimationMixer基底クラス定義
- E-04: `scene/animation/animation_mixer.cpp` - AnimationMixer実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationPlayerはキーフレームベースのアニメーション再生ノード | E-01, E-02 | ○ |
| C-02 | AnimationLibraryを通じて複数のアニメーションを管理 | E-04 (304-339行目) | ○ |
| C-03 | AnimationMixerを継承している | E-01 (class AnimationPlayer : public AnimationMixer) | ○ |
| C-04 | play()メソッドでアニメーション再生 | E-02 (134-206行目) | ○ |
| C-05 | stop()メソッドで再生停止 | E-02 (_bind_methods内) | ○ |
| C-06 | queue()メソッドでキュー再生 | E-02 (_bind_methods内) | ○ |
| C-07 | animation_finishedシグナルが存在 | E-02 (703行目) | ○ |
| C-08 | animation_startedシグナルが存在 | E-02 (704行目) | ○ |
| C-09 | current_animation_changedシグナルが存在 | E-02 (705行目) | ○ |
| C-10 | playback_default_blend_timeプロパティが存在 | E-02 (733行目) | ○ |
| C-11 | speed_scaleプロパティが存在 | E-03 (AnimationMixer) | ○ |
| C-12 | autoplayプロパティが存在 | E-02 (736行目) | ○ |
| C-13 | seek()メソッドで位置指定が可能 | E-02 (_bind_methods内) | ○ |
| C-14 | set_blend_time()でブレンド時間設定が可能 | E-02 (717行目) | ○ |
| C-15 | is_playing()で再生状態を取得可能 | E-02 (_bind_methods内) | ○ |
| C-16 | play_backwards()で逆再生が可能 | E-02 (_bind_methods内) | ○ |
| C-17 | pause()で一時停止が可能 | E-02 (_bind_methods内) | ○ |
| C-18 | clear_queue()でキュークリアが可能 | E-02 (_bind_methods内) | ○ |
| C-19 | get_queue()でキュー内容取得が可能 | E-02 (_bind_methods内) | ○ |
| C-20 | Godot 3.xからの互換性サポート（anims/プレフィックス） | E-04 (59-71行目) | ○ |
| C-21 | トラックキャッシュによる高速プロパティアクセス | E-04 (track_cache) | ○ |
| C-22 | movie_quit_on_finishプロパティが存在 | E-02 (738行目) | ○ |
| C-23 | 関連画面がアニメーションエディタパネル | **根拠なし** | △ |
| C-24 | 増分更新による不要な計算の削減 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-23: エディタ関連のコードを確認していないため、パネル名の正確性は未検証
  - 候補：editor/plugins/animation_player_editor_plugin.cpp / animation_dock.cpp
- C-24: 増分更新の具体的な実装箇所の特定が必要
  - 候補：animation_mixer.cpp内の差分更新ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述はソースコードと整合
- 1: 中リスク - エディタ関連の記述は要確認
- 0: 低リスク - APIメソッド・シグナルはbind_methodsで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] animation_player.hのクラス定義を確認
- [ ] _bind_methods()内のメソッド・プロパティ・シグナル登録を確認
- [ ] エディタプラグインでのパネル名を確認
- [ ] 処理フローがコードの実装と一致しているか確認
