---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 32-AnimationTree

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **ブレンドスペースの三角形補間**：詳細アルゴリズムの確認が必要
  2. **カスタムAnimationNodeの作成方法**：ドキュメント・サンプルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/animation/animation_tree.h` - AnimationTreeクラス定義
- E-02: `scene/animation/animation_tree.cpp` - AnimationTree実装
- E-03: `scene/animation/animation_blend_tree.h` - AnimationNodeBlendTree定義
- E-04: `scene/animation/animation_blend_tree.cpp` - ブレンドツリー実装
- E-05: `scene/animation/animation_node_state_machine.h` - ステートマシン定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationTreeはAnimationMixerを継承 | E-01 | ○ |
| C-02 | ブレンドツリーで複数アニメーションをブレンド可能 | E-03, E-04 | ○ |
| C-03 | ステートマシンで状態遷移が可能 | E-05 | ○ |
| C-04 | tree_rootプロパティが存在 | E-01, E-02 | ○ |
| C-05 | anim_playerプロパティが存在 | E-02 (_bind_methods) | ○ |
| C-06 | get_root_motion_position()メソッドが存在 | E-01, E-02 | ○ |
| C-07 | get_root_motion_rotation()メソッドが存在 | E-01, E-02 | ○ |
| C-08 | AnimationNodeBlend2ノードが存在 | E-03 | ○ |
| C-09 | AnimationNodeBlend3ノードが存在 | E-03 | ○ |
| C-10 | AnimationNodeBlendSpace1Dノードが存在 | Glob結果 | ○ |
| C-11 | AnimationNodeBlendSpace2Dノードが存在 | Glob結果 | ○ |
| C-12 | AnimationNodeOneShotノードが存在 | E-03 | ○ |
| C-13 | AnimationNodeTimeScaleノードが存在 | E-03 | ○ |
| C-14 | AnimationNodeTransitionノードが存在 | E-03 | ○ |
| C-15 | AnimationNodeAdd2ノードが存在 | E-03 | ○ |
| C-16 | AnimationNodeAnimationノードが存在 | E-03 | ○ |
| C-17 | animation_startedシグナルが存在 | E-02 | ○ |
| C-18 | animation_finishedシグナルが存在 | E-02 | ○ |
| C-19 | パラメータマップでブレンド量を制御 | E-02 | ○ |
| C-20 | blend_input()でブレンド計算を行う | E-04 | ○ |
| C-21 | ルートモーション抽出機能がある | E-01, E-02 | ○ |
| C-22 | travel()でステートマシン遷移が可能 | E-05 | ○ |
| C-23 | callback_mode_processプロパティが存在 | E-02 | ○ |
| C-24 | advance_expression_base_nodeプロパティが存在 | E-02 | ○ |
| C-25 | 三角形補間によるBlendSpace2Dのウェイト計算 | **根拠不足** | △ |
| C-26 | カスタムAnimationNodeの作成が可能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: BlendSpace2Dの三角形補間アルゴリズムの詳細実装
  - 候補：animation_blend_space_2d.cpp の _blend_space_process()
- C-26: カスタムAnimationNode作成のドキュメントまたはサンプル
  - 候補：公式ドキュメント / demos/animation_tree/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AnimationTree基本構造はソースコードで確認済み
- 1: 中リスク - ブレンドスペースの詳細アルゴリズムは要確認
- 0: 低リスク - ステートマシン遷移ロジックはソースで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] animation_tree.hのクラス定義を確認
- [ ] AnimationNodeBlendTree系ノードの実装を確認
- [ ] ステートマシンのtravel()実装を確認
- [ ] ルートモーション関連メソッドの動作を確認
