---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 33-Tween

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **TRANS_SPRINGの存在**：ソースコードでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/animation/tween.h` - Tweenクラス定義
- E-02: `scene/animation/tween.cpp` - Tween実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TweenはRefCountedを継承 | E-01 | ○ |
| C-02 | tween_property()でプロパティ補間を追加 | E-02 | ○ |
| C-03 | tween_interval()で待機時間を追加 | E-02 | ○ |
| C-04 | tween_callback()でコールバックを追加 | E-02 | ○ |
| C-05 | tween_method()でメソッド補間を追加 | E-02 | ○ |
| C-06 | PropertyTweenerクラスが存在 | E-01 | ○ |
| C-07 | IntervalTweenerクラスが存在 | E-01 | ○ |
| C-08 | CallbackTweenerクラスが存在 | E-01 | ○ |
| C-09 | MethodTweenerクラスが存在 | E-01 | ○ |
| C-10 | set_parallel()メソッドが存在 | E-02 | ○ |
| C-11 | set_loops()メソッドが存在 | E-02 | ○ |
| C-12 | set_trans()メソッドが存在 | E-02 | ○ |
| C-13 | set_ease()メソッドが存在 | E-02 | ○ |
| C-14 | bind_node()メソッドが存在 | E-02 | ○ |
| C-15 | from()メソッドが存在（PropertyTweener） | E-02 | ○ |
| C-16 | as_relative()メソッドが存在 | E-02 | ○ |
| C-17 | set_custom_interpolator()メソッドが存在 | E-02 | ○ |
| C-18 | finishedシグナルが存在 | E-02 | ○ |
| C-19 | step_finishedシグナルが存在 | E-02 | ○ |
| C-20 | loop_finishedシグナルが存在 | E-02 | ○ |
| C-21 | TRANS_LINEAR定数が存在 | E-01, E-02 | ○ |
| C-22 | TRANS_BOUNCE定数が存在 | E-01, E-02 | ○ |
| C-23 | TRANS_ELASTIC定数が存在 | E-01, E-02 | ○ |
| C-24 | EASE_IN/OUT/IN_OUT/OUT_IN定数が存在 | E-01, E-02 | ○ |
| C-25 | stop()/pause()/play()メソッドが存在 | E-02 | ○ |
| C-26 | is_running()/is_valid()メソッドが存在 | E-02 | ○ |
| C-27 | parallel()/chain()メソッドが存在 | E-02 | ○ |
| C-28 | TRANS_SPRING定数が存在 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: TRANS_SPRINGがGodot 4.xで追加されたか要確認
  - 候補：tween.h内のTransitionType enum定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Tweenの基本API・シグナルはソースで確認済み
- 0: 低リスク - イージング関数は標準的なもの
- 1: 中リスク - TRANS_SPRINGは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] tween.hのTweenクラス定義を確認
- [ ] _bind_methods()内のメソッド・シグナル登録を確認
- [ ] TransitionType enumの全定数を確認
- [ ] step()メソッドの処理フローを確認
