---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 34-スケルトン_ボーン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **bone_pose_changedシグナル**：実際の実装での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/skeleton_3d.h` - Skeleton3Dクラス定義
- E-02: `scene/3d/skeleton_3d.cpp` - Skeleton3D実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Skeleton3DはNode3Dを継承 | E-01 (65行目) | ○ |
| C-02 | Bone構造体が内部で定義されている | E-01 (99-134行目) | ○ |
| C-03 | add_bone()でボーンを追加可能 | E-01 (226行目) | ○ |
| C-04 | find_bone()でボーン検索が可能 | E-01 (227行目) | ○ |
| C-05 | get_bone_name()/set_bone_name()が存在 | E-01 (228-229行目) | ○ |
| C-06 | get_bone_parent()/set_bone_parent()が存在 | E-01 (234-235行目) | ○ |
| C-07 | get_bone_count()が存在 | E-01 (242行目) | ○ |
| C-08 | get_bone_rest()/set_bone_rest()が存在 | E-01 (244-245行目) | ○ |
| C-09 | get_bone_global_rest()が存在 | E-01 (246行目) | ○ |
| C-10 | get_bone_pose()/set_bone_pose()が存在 | E-01 (265, 269行目) | ○ |
| C-11 | get_bone_pose_position()/set_bone_pose_position()が存在 | E-01 (266, 270行目) | ○ |
| C-12 | get_bone_pose_rotation()/set_bone_pose_rotation()が存在 | E-01 (267, 271行目) | ○ |
| C-13 | get_bone_pose_scale()/set_bone_pose_scale()が存在 | E-01 (268, 272行目) | ○ |
| C-14 | get_bone_global_pose()/set_bone_global_pose()が存在 | E-01 (274-275行目) | ○ |
| C-15 | reset_bone_pose()/reset_bone_poses()が存在 | E-01 (277-278行目) | ○ |
| C-16 | is_bone_enabled()/set_bone_enabled()が存在 | E-01 (248-249行目) | ○ |
| C-17 | clear_bones()が存在 | E-01 (253行目) | ○ |
| C-18 | create_skin_from_rest_transforms()が存在 | E-01 (282行目) | ○ |
| C-19 | register_skin()が存在 | E-01 (284行目) | ○ |
| C-20 | force_update_all_bone_transforms()が存在 | E-01 (288行目) | ○ |
| C-21 | motion_scaleプロパティが存在 | E-01 (255-256行目) | ○ |
| C-22 | show_rest_onlyプロパティが存在 | E-01 (251-252行目) | ○ |
| C-23 | Bone構造体にname, parent, rest等が含まれる | E-01 (100-114行目) | ○ |
| C-24 | pose_cache_dirtyフラグでキャッシュ管理 | E-01 (109行目) | ○ |
| C-25 | update_pose_cache()でキャッシュ更新 | E-01 (118-124行目) | ○ |
| C-26 | SkinReferenceクラスが存在 | E-01 (41-63行目) | ○ |
| C-27 | NOTIFICATION_UPDATE_SKELETONが定義 | E-01 (221行目) | ○ |
| C-28 | nested_set_offset/nested_set_spanによる効率化 | E-01 (115-116行目) | ○ |
| C-29 | ModifierCallbackModeProcessが定義 | E-01 (79-83行目) | ○ |
| C-30 | bone_pose_changedシグナルが存在 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-30: bone_pose_changedシグナルの実装を確認
  - 候補：skeleton_3d.cpp内の_bind_methods()でのシグナル登録

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Skeleton3Dの基本構造・メソッドは全て確認済み
- 0: 低リスク - Bone構造体のフィールドはヘッダーで確認
- 1: 中リスク - 一部シグナルの存在は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] skeleton_3d.hのBone構造体定義を確認
- [ ] _bind_methods()内のメソッド・シグナル登録を確認
- [ ] _force_update_all_bone_transforms()の処理フローを確認
- [ ] SkinReferenceとRenderingServerの連携を確認
