---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 35-IK

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **interpolationプロパティ**：SkeletonIK3Dでの存在確認が必要
  2. **2D IK関連クラス構造**：詳細な確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/skeleton_ik_3d.h` - SkeletonIK3Dクラス定義
- E-02: `scene/3d/skeleton_ik_3d.cpp` - FABRIK実装
- E-03: `scene/3d/ccd_ik_3d.h` - CCDIK3D定義
- E-04: `scene/3d/ccd_ik_3d.cpp` - CCDIK実装
- E-05: `scene/resources/2d/skeleton/skeleton_modification_2d_ccdik.cpp` - 2D CCDIK
- E-06: `scene/resources/2d/skeleton/skeleton_modification_2d_fabrik.cpp` - 2D FABRIK
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FABRIKアルゴリズムが実装されている | E-02 (126-287行目) | ○ |
| C-02 | CCDIKアルゴリズムが実装されている | E-04 (33-71行目) | ○ |
| C-03 | SkeletonIK3DがSkeletonModifier3Dを継承 | E-01 | ○ |
| C-04 | FabrikInverseKinematicクラスが存在 | E-02 (33行目〜) | ○ |
| C-05 | ChainItem構造体が存在 | E-02 (ChainItem) | ○ |
| C-06 | EndEffector構造体が存在 | E-02 | ○ |
| C-07 | solve_simple_backwards()が存在 | E-02 (141-171行目) | ○ |
| C-08 | solve_simple_forwards()が存在 | E-02 (173-207行目) | ○ |
| C-09 | build_chain()が存在 | E-02 (51-124行目) | ○ |
| C-10 | _solve_iteration()が存在（CCDIK） | E-04 (33-71行目) | ○ |
| C-11 | root_boneプロパティが存在 | E-01 | ○ |
| C-12 | tip_boneプロパティが存在 | E-01 | ○ |
| C-13 | target_nodeプロパティが存在 | E-01 | ○ |
| C-14 | use_magnetプロパティが存在 | E-01 | ○ |
| C-15 | magnetプロパティが存在 | E-01 | ○ |
| C-16 | max_iterationsプロパティが存在 | E-01 | ○ |
| C-17 | min_distanceプロパティが存在 | E-01 | ○ |
| C-18 | override_tip_basisプロパティが存在 | E-01 | ○ |
| C-19 | start()/stop()/is_running()メソッドが存在 | E-01 | ○ |
| C-20 | 回転制約機能がある（CCDIK） | E-04 (63-68行目) | ○ |
| C-21 | 2D用CCDIK/FABRIKが存在 | E-05, E-06 (Globで確認) | ○ |
| C-22 | Quaternionで回転計算を行う | E-04 (58行目) | ○ |
| C-23 | set_bone_global_pose()で結果を適用 | E-02 (279行目) | ○ |
| C-24 | interpolationプロパティが存在 | **根拠不足** | △ |
| C-25 | 2D IKのクラス階層構造 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: interpolationプロパティの存在確認
  - 候補：skeleton_ik_3d.h内のプロパティ定義
- C-25: 2D IK関連のクラス階層の詳細
  - 候補：skeleton_modification_2d.h, skeleton_modification_stack_2d.h

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - FABRIK/CCDIKのコアアルゴリズムはソースで確認済み
- 1: 中リスク - 一部プロパティ・2D IK構造は要確認
- 0: 低リスク - 主要メソッドはソースで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] skeleton_ik_3d.hのプロパティ定義を確認
- [ ] solve_simple_backwards/forwards()のアルゴリズムを確認
- [ ] ccd_ik_3d.cppの_solve_iteration()を確認
- [ ] 2D IK関連ファイルのクラス構造を確認
