---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 36-2Dナビゲーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **A*アルゴリズムの実装詳細**：NavigationServer2D内部の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/2d/navigation/navigation_agent_2d.h` - NavigationAgent2D定義
- E-02: `scene/2d/navigation/navigation_agent_2d.cpp` - エージェント実装
- E-03: `scene/2d/navigation/navigation_region_2d.h` - NavigationRegion2D定義
- E-04: `scene/2d/navigation/navigation_link_2d.h` - NavigationLink2D定義
- E-05: `scene/2d/navigation/navigation_obstacle_2d.h` - NavigationObstacle2D定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NavigationAgent2DがNode継承 | E-02 (31行目: include) | ○ |
| C-02 | target_positionプロパティが存在 | E-02 (89-90行目) | ○ |
| C-03 | path_desired_distanceプロパティが存在 | E-02 (44-45行目) | ○ |
| C-04 | avoidance_enabledプロパティが存在 | E-02 (41-42行目) | ○ |
| C-05 | radiusプロパティが存在 | E-02 (50-51行目) | ○ |
| C-06 | max_speedプロパティが存在 | E-02 (65-66行目) | ○ |
| C-07 | navigation_layersプロパティが存在 | E-02 (71-72行目) | ○ |
| C-08 | pathfinding_algorithmプロパティが存在 | E-02 (77-78行目) | ○ |
| C-09 | path_postprocessingプロパティが存在 | E-02 (80-81行目) | ○ |
| C-10 | get_rid()メソッドが存在 | E-02 (39行目) | ○ |
| C-11 | get_next_path_position()メソッドが存在 | E-02 (112行目) | ○ |
| C-12 | is_target_reached()メソッドが存在 | E-02 (125行目) | ○ |
| C-13 | is_target_reachable()メソッドが存在 | E-02 (126行目) | ○ |
| C-14 | is_navigation_finished()メソッドが存在 | E-02 (127行目) | ○ |
| C-15 | get_current_navigation_path()メソッドが存在 | E-02 (123行目) | ○ |
| C-16 | set_velocity()メソッドが存在 | E-02 (116行目) | ○ |
| C-17 | path_changedシグナルが存在 | E-02 (190行目) | ○ |
| C-18 | target_reachedシグナルが存在 | E-02 (191行目) | ○ |
| C-19 | waypoint_reachedシグナルが存在 | E-02 (192行目) | ○ |
| C-20 | link_reachedシグナルが存在 | E-02 (193行目) | ○ |
| C-21 | navigation_finishedシグナルが存在 | E-02 (194行目) | ○ |
| C-22 | velocity_computedシグナルが存在 | E-02 (195行目) | ○ |
| C-23 | NavigationServer2D::agent_create()でエージェント生成 | E-02 (322行目) | ○ |
| C-24 | RVO（障害物回避）が実装されている | E-02 (159-170行目, avoidance) | ○ |
| C-25 | debug_enabledプロパティが存在 | E-02 (172-173行目) | ○ |
| C-26 | avoidance_priorityプロパティが存在 | E-02 (140-141行目) | ○ |
| C-27 | time_horizon_agentsプロパティが存在 | E-02 (59-60行目) | ○ |
| C-28 | time_horizon_obstaclesプロパティが存在 | E-02 (62-63行目) | ○ |
| C-29 | simplify_pathプロパティが存在 | E-02 (92-93行目) | ○ |
| C-30 | path_search_max_polygonsプロパティが存在 | E-02 (104-105行目) | ○ |
| C-31 | _avoidance_done()コールバックが存在 | E-02 (130行目) | ○ |
| C-32 | A*アルゴリズムによる経路探索 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-32: A*アルゴリズムの実装詳細
  - 候補：servers/navigation_2d/navigation_server_2d.cpp内の経路探索処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NavigationAgent2Dの主要プロパティ・メソッド・シグナルは全て確認済み
- 0: 低リスク - 障害物回避関連の設定は確認済み
- 1: 中リスク - NavigationServer2D内部のA*実装は詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] navigation_agent_2d.cppの_bind_methods()を確認
- [ ] シグナル登録（190-195行目）を確認
- [ ] コンストラクタでのNavigationServer2D初期化を確認
- [ ] NavigationServer2D内部の経路探索アルゴリズムを確認
