---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 37-3Dナビゲーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **NavigationMeshのベイク処理詳細**：確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/navigation/navigation_agent_3d.h` - NavigationAgent3D定義
- E-02: `scene/3d/navigation/navigation_agent_3d.cpp` - エージェント実装
- E-03: `scene/3d/navigation/navigation_region_3d.h` - NavigationRegion3D定義
- E-04: `scene/3d/navigation/navigation_link_3d.h` - NavigationLink3D定義
- E-05: `scene/3d/navigation/navigation_obstacle_3d.h` - NavigationObstacle3D定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NavigationAgent3DがNode継承 | E-02 | ○ |
| C-02 | target_position (Vector3)プロパティが存在 | E-02 (99-100行目) | ○ |
| C-03 | heightプロパティが存在 | E-02 (51-52行目) | ○ |
| C-04 | path_height_offsetプロパティが存在 | E-02 (54-55行目) | ○ |
| C-05 | use_3d_avoidanceプロパティが存在 | E-02 (57-58行目) | ○ |
| C-06 | keep_y_velocityプロパティが存在 | E-02 (60-61行目) | ○ |
| C-07 | radiusプロパティが存在 | E-02 (48-49行目) | ○ |
| C-08 | avoidance_enabledプロパティが存在 | E-02 (39-40行目) | ○ |
| C-09 | max_speedプロパティが存在 | E-02 (75-76行目) | ○ |
| C-10 | get_next_path_position()がVector3を返す | E-02 (122行目) | ○ |
| C-11 | get_current_navigation_path()がPackedVector3Arrayを返す | E-02 (133行目) | ○ |
| C-12 | velocity_computedシグナルがVector3を渡す | E-02 (191行目) | ○ |
| C-13 | path_changedシグナルが存在 | E-02 (186行目) | ○ |
| C-14 | target_reachedシグナルが存在 | E-02 (187行目) | ○ |
| C-15 | navigation_finishedシグナルが存在 | E-02 (190行目) | ○ |
| C-16 | stored_y_velocityでY速度を保存 | E-02 (323行目) | ○ |
| C-17 | velocity.y = 0.0 で2D計算 | E-02 (325行目) | ○ |
| C-18 | _validate_property()でkeep_y_velocityを条件付き表示 | E-02 (346-351行目) | ○ |
| C-19 | NavigationServer3D::agent_create()でエージェント生成 | E-02 (354行目) | ○ |
| C-20 | agent_set_height()が呼ばれる | E-02 (361行目) | ○ |
| C-21 | agent_set_use_3d_avoidance()が呼ばれる | E-02 (366行目) | ○ |
| C-22 | path_search_max_polygonsプロパティが存在 | E-02 (114-115行目) | ○ |
| C-23 | avoidance_priorityプロパティが存在 | E-02 (150-151行目) | ○ |
| C-24 | waypoint_reachedシグナルが存在 | E-02 (188行目) | ○ |
| C-25 | link_reachedシグナルが存在 | E-02 (189行目) | ○ |
| C-26 | simplify_pathプロパティが存在 | E-02 (102-103行目) | ○ |
| C-27 | debug_enabledプロパティが存在 | E-02 (193-194行目) | ○ |
| C-28 | NavigationMeshのベイク処理詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: NavigationMeshのベイク処理の詳細実装
  - 候補：scene/resources/3d/navigation_mesh.cpp, servers/navigation_3d/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NavigationAgent3Dの主要プロパティ・メソッド・シグナルは全て確認済み
- 0: 低リスク - 3D固有機能（height, use_3d_avoidance, keep_y_velocity）は確認済み
- 1: 中リスク - NavigationMesh関連の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] navigation_agent_3d.cppの_bind_methods()を確認
- [ ] Y速度保持処理（317-327行目）を確認
- [ ] _validate_property()でのプロパティ条件付き表示を確認
- [ ] NavigationMeshリソースの詳細を確認
