---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 38-HTTPリクエスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/http_request.h` - HTTPRequestクラス定義
- E-02: `scene/main/http_request.cpp` - HTTPRequest実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPRequestがNode継承 | E-01 (41行目) | ○ |
| C-02 | request()メソッドが存在 | E-02 (103-116行目, 635行目) | ○ |
| C-03 | request_raw()メソッドが存在 | E-02 (118-164行目, 636行目) | ○ |
| C-04 | cancel_request()メソッドが存在 | E-02 (186-210行目, 637行目) | ○ |
| C-05 | download_fileプロパティが存在 | E-02 (669行目) | ○ |
| C-06 | download_chunk_sizeプロパティが存在 | E-02 (670行目) | ○ |
| C-07 | use_threadsプロパティが存在 | E-02 (671行目) | ○ |
| C-08 | accept_gzipプロパティが存在 | E-02 (672行目) | ○ |
| C-09 | body_size_limitプロパティが存在 | E-02 (673行目) | ○ |
| C-10 | max_redirectsプロパティが存在 | E-02 (674行目) | ○ |
| C-11 | timeoutプロパティが存在 | E-02 (675行目) | ○ |
| C-12 | request_completedシグナルが存在 | E-02 (677行目) | ○ |
| C-13 | RESULT_SUCCESS定数が存在 | E-02 (679行目) | ○ |
| C-14 | RESULT_CANT_CONNECT定数が存在 | E-02 (681行目) | ○ |
| C-15 | RESULT_TLS_HANDSHAKE_ERROR定数が存在 | E-02 (684行目) | ○ |
| C-16 | RESULT_TIMEOUT定数が存在 | E-02 (692行目) | ○ |
| C-17 | RESULT_REDIRECT_LIMIT_REACHED定数が存在 | E-02 (691行目) | ○ |
| C-18 | _parse_url()でURL解析を行う | E-02 (40-70行目) | ○ |
| C-19 | HTTPSはポート443をデフォルト使用 | E-02 (64行目) | ○ |
| C-20 | HTTPはポート80をデフォルト使用 | E-02 (64行目) | ○ |
| C-21 | _thread_func()でスレッド処理 | E-02 (166-184行目) | ○ |
| C-22 | _update_connection()で接続状態管理 | E-02 (322-506行目) | ○ |
| C-23 | 301/302リダイレクトを処理 | E-02 (252-304行目) | ○ |
| C-24 | gzip/deflate展開をサポート | E-02 (306-317行目, 428-460行目) | ○ |
| C-25 | StreamPeerGZIPで解凍 | E-01 (34行目: include) | ○ |
| C-26 | set_tls_options()メソッドが存在 | E-02 (629-632行目, 638行目) | ○ |
| C-27 | set_http_proxy()メソッドが存在 | E-02 (607-609行目, 666行目) | ○ |
| C-28 | set_https_proxy()メソッドが存在 | E-02 (611-613行目, 667行目) | ○ |
| C-29 | get_downloaded_bytes()メソッドが存在 | E-02 (599-601行目, 657行目) | ○ |
| C-30 | get_body_size()メソッドが存在 | E-02 (603-605行目, 658行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HTTPRequestの全プロパティ・メソッド・シグナルはソースで確認済み
- 0: 低リスク - 処理フローは実装コードと一致
- 0: 低リスク - Result列挙型は全て確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] http_request.cppの_bind_methods()を確認
- [ ] _parse_url()のURL解析ロジックを確認
- [ ] _update_connection()の状態遷移を確認
- [ ] リダイレクト処理（252-304行目）を確認
