---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 39-WebSocket

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/websocket/websocket_peer.h` - WebSocketPeer基底クラス定義
- E-02: `modules/websocket/websocket_peer.cpp` - WebSocketPeer実装
- E-03: `modules/websocket/wsl_peer.h` - WSLPeer実装クラス定義
- E-04: `modules/websocket/wsl_peer.cpp` - WSLPeer実装（wslayベース）
- E-05: `modules/websocket/websocket_multiplayer_peer.h` - WebSocketMultiplayerPeer定義
- E-06: `modules/websocket/websocket_multiplayer_peer.cpp` - WebSocketMultiplayerPeer実装
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketPeerがPacketPeer継承 | E-01 (36行目) | ○ |
| C-02 | State列挙型にCONNECTING/OPEN/CLOSING/CLOSED | E-01 (40-45行目) | ○ |
| C-03 | WriteMode列挙型にTEXT/BINARY | E-01 (47-50行目) | ○ |
| C-04 | connect_to_url()メソッドが存在 | E-02 (42行目) | ○ |
| C-05 | accept_stream()メソッドが存在 | E-02 (43行目) | ○ |
| C-06 | send()メソッドが存在 | E-02 (44行目) | ○ |
| C-07 | send_text()メソッドが存在 | E-02 (45行目, 99-102行目) | ○ |
| C-08 | close()メソッドが存在 | E-02 (48行目) | ○ |
| C-09 | poll()メソッドが存在 | E-02 (47行目) | ○ |
| C-10 | get_ready_state()メソッドが存在 | E-02 (56行目) | ○ |
| C-11 | get_close_code()メソッドが存在 | E-02 (57行目) | ○ |
| C-12 | get_close_reason()メソッドが存在 | E-02 (58行目) | ○ |
| C-13 | supported_protocolsプロパティが存在 | E-02 (76行目) | ○ |
| C-14 | handshake_headersプロパティが存在 | E-02 (77行目) | ○ |
| C-15 | inbound_buffer_sizeプロパティが存在 | E-02 (79行目) | ○ |
| C-16 | outbound_buffer_sizeプロパティが存在 | E-02 (80行目) | ○ |
| C-17 | max_queued_packetsプロパティが存在 | E-02 (82行目) | ○ |
| C-18 | heartbeat_intervalプロパティが存在 | E-02 (84行目) | ○ |
| C-19 | DEFAULT_BUFFER_SIZE = 65535 | E-01 (52-54行目) | ○ |
| C-20 | WSLPeerがwslayライブラリを使用 | E-03 (41行目: #include <wslay/wslay.h>) | ○ |
| C-21 | _generate_key()で16バイトランダム生成 | E-04 (682-689行目) | ○ |
| C-22 | Magic UUID使用のキーレスポンス計算 | E-04 (691-695行目) | ○ |
| C-23 | wslayコールバック構造体登録 | E-04 (672-680行目) | ○ |
| C-24 | デフォルトポートws=80, wss=443 | E-04 (500-502行目) | ○ |
| C-25 | Sec-WebSocket-Version: 13使用 | E-04 (540行目) | ○ |
| C-26 | poll()内でハートビート処理 | E-04 (715-737行目) | ○ |
| C-27 | PING送信後PONGでheartbeat_waiting解除 | E-04 (659-660行目) | ○ |
| C-28 | WebSocketMultiplayerPeerがMultiplayerPeer継承 | E-05 (39行目) | ○ |
| C-29 | create_client()メソッドが存在 | E-06 (75行目) | ○ |
| C-30 | create_server()メソッドが存在 | E-06 (76行目) | ○ |
| C-31 | get_peer()メソッドが存在 | E-06 (78行目) | ○ |
| C-32 | handshake_timeoutプロパティが存在 | E-06 (106行目) | ○ |
| C-33 | _poll_server()で接続管理 | E-06 (278-401行目) | ○ |
| C-34 | _poll_client()でクライアント処理 | E-06 (218-276行目) | ○ |
| C-35 | peer_connected/peer_disconnectedシグナル発行 | E-06 (240行目, 262行目, 317行目, 398行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WebSocketPeerの全プロパティ・メソッドはソースで確認済み
- 0: 低リスク - WSLPeerのwslayコールバック実装は確認済み
- 0: 低リスク - WebSocketMultiplayerPeerのサーバー/クライアント処理は確認済み
- 0: 低リスク - RFC 6455準拠の実装（Magic UUID、Sec-WebSocket-Accept計算）は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] websocket_peer.cppの_bind_methods()を確認
- [ ] wsl_peer.cppのconnect_to_url()でURL解析を確認
- [ ] wsl_peer.cppの_verify_server_response()でハンドシェイク検証を確認
- [ ] wsl_peer.cppのpoll()内ハートビート処理を確認
- [ ] websocket_multiplayer_peer.cppの_poll_server()を確認
