---
generated_at: 2026-01-23 11:25:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 40-マルチプレイヤー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/multiplayer_api.h` - MultiplayerAPI基底クラス定義
- E-02: `scene/main/multiplayer_peer.h` - MultiplayerPeer基底クラス定義
- E-03: `modules/multiplayer/scene_multiplayer.h` - SceneMultiplayer定義
- E-04: `modules/multiplayer/scene_multiplayer.cpp` - SceneMultiplayer実装
- E-05: `modules/multiplayer/scene_rpc_interface.h` - RPC処理インターフェース定義
- E-06: `modules/multiplayer/scene_rpc_interface.cpp` - RPC処理実装
- E-07: `modules/multiplayer/multiplayer_spawner.h` - MultiplayerSpawner定義
- E-08: `modules/multiplayer/multiplayer_synchronizer.h` - MultiplayerSynchronizer定義
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SceneMultiplayerがMultiplayerAPI継承 | E-03 (64行目) | ○ |
| C-02 | NetworkCommands列挙型が存在 | E-03 (68-77行目) | ○ |
| C-03 | NETWORK_COMMAND_REMOTE_CALL = 0 | E-03 (69行目) | ○ |
| C-04 | NETWORK_COMMAND_SPAWN = 4 | E-03 (73行目) | ○ |
| C-05 | NETWORK_COMMAND_SYNC = 6 | E-03 (75行目) | ○ |
| C-06 | SysCommands列挙型が存在 | E-03 (79-84行目) | ○ |
| C-07 | auth_timeoutプロパティが存在 | E-04 (667行目) | ○ |
| C-08 | root_pathプロパティが存在 | E-04 (665行目) | ○ |
| C-09 | auth_callbackプロパティが存在 | E-04 (666行目) | ○ |
| C-10 | server_relayプロパティが存在 | E-04 (670行目) | ○ |
| C-11 | allow_object_decodingプロパティが存在 | E-04 (668行目) | ○ |
| C-12 | poll()メソッドが存在 | E-04 (65-165行目) | ○ |
| C-13 | clear()メソッドが存在 | E-04 (639行目) | ○ |
| C-14 | disconnect_peer()メソッドが存在 | E-04 (641行目) | ○ |
| C-15 | send_bytes()メソッドが存在 | E-04 (658行目) | ○ |
| C-16 | send_auth()メソッドが存在 | E-04 (644行目) | ○ |
| C-17 | complete_auth()メソッドが存在 | E-04 (645行目) | ○ |
| C-18 | peer_authenticatingシグナルが存在 | E-04 (676行目) | ○ |
| C-19 | peer_authentication_failedシグナルが存在 | E-04 (677行目) | ○ |
| C-20 | peer_packetシグナルが存在 | E-04 (678行目) | ○ |
| C-21 | _process_packet()でコマンド判定 | E-04 (213-249行目) | ○ |
| C-22 | CMD_MASK = 7で下位3ビット抽出 | E-03 (99-101行目) | ○ |
| C-23 | MultiplayerPeerがPacketPeer継承 | E-02 (39行目) | ○ |
| C-24 | TransferMode列挙型が存在 | E-02 (43-47行目) | ○ |
| C-25 | ConnectionStatus列挙型が存在 | E-02 (63-67行目) | ○ |
| C-26 | TARGET_PEER_BROADCAST = 0 | E-02 (59行目) | ○ |
| C-27 | TARGET_PEER_SERVER = 1 | E-02 (60行目) | ○ |
| C-28 | RPCMode列挙型が存在 | E-01 (47-51行目) | ○ |
| C-29 | SceneRPCInterface::rpcp()でRPC送信 | E-06 (471-532行目) | ○ |
| C-30 | _send_rpc()でパケット構築 | E-06 (303-469行目) | ○ |
| C-31 | process_rpc()でRPC受信処理 | E-06 (155-226行目) | ○ |
| C-32 | _process_rpc()で権限チェック | E-06 (248-259行目) | ○ |
| C-33 | ノードID圧縮（8/16/32ビット） | E-06 (365-392行目) | ○ |
| C-34 | RPCConfigにrpc_mode/transfer_mode/call_local | E-05 (45-51行目) | ○ |
| C-35 | _add_peer()で認証判定 | E-04 (355-364行目) | ○ |
| C-36 | _admit_peer()でサーバーリレー通知 | E-04 (366-393行目) | ○ |
| C-37 | send_command()でリレー処理 | E-04 (258-284行目) | ○ |
| C-38 | MultiplayerSpawnerがNode継承 | E-07 (37行目) | ○ |
| C-39 | MultiplayerSynchronizerがNode継承 | E-08 (37行目) | ○ |
| C-40 | VisibilityUpdateMode列挙型が存在 | E-08 (41-45行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SceneMultiplayerの全プロパティ・メソッド・シグナルはソースで確認済み
- 0: 低リスク - RPC送受信フローは実装コードと一致
- 0: 低リスク - 認証フローは実装コードと一致
- 0: 低リスク - サーバーリレー処理は実装コードと一致
- 0: 低リスク - NetworkCommands/SysCommands列挙型は全て確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] scene_multiplayer.cppの_bind_methods()を確認
- [ ] poll()内のパケット処理ループを確認
- [ ] scene_rpc_interface.cppのrpcp()とprocess_rpc()を確認
- [ ] _process_rpc()内の権限チェック（248-259行目）を確認
- [ ] send_command()内のリレー処理（258-284行目）を確認
- [ ] _add_peer()と_admit_peer()の認証フローを確認
