---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-ENet

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：公式ドキュメントでの確認推奨
  2. **DTLS暗号化の詳細仕様**：セキュリティ要件の追加確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/enet/enet_multiplayer_peer.h` - ENetMultiplayerPeerクラス定義
- E-02: `modules/enet/enet_multiplayer_peer.cpp` - ENetMultiplayerPeer実装
- E-03: `modules/enet/enet_connection.h` - ENetConnectionクラス定義
- E-04: `modules/enet/enet_connection.cpp` - ENetConnection実装
- E-05: `modules/enet/enet_packet_peer.h` - ENetPacketPeerクラス定義
- E-06: `modules/enet/enet_packet_peer.cpp` - ENetPacketPeer実装
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ENetはMultiplayerPeerを継承したマルチプレイヤー通信クラス | E-01 (40行目: GDCLASS) | ○ |
| C-02 | サーバー/クライアント/メッシュの3モードをサポート | E-01 (55-60行目: Mode enum) | ○ |
| C-03 | サーバーのunique_idは1に固定 | E-02 (71行目: unique_id = 1) | ○ |
| C-04 | クライアントIDは2以上が必要 | E-02 (206行目: event.data < 2) | ○ |
| C-05 | システムチャンネルは2個（RELIABLE/UNRELIABLE）予約 | E-01 (49-53行目: SYSCH enum) | ○ |
| C-06 | 最大接続数は4095クライアント | E-04 (307行目: max_peers制限) | ○ |
| C-07 | パケット最大サイズは2^24バイト | E-02 (418行目), E-06 (84行目) | ○ |
| C-08 | 圧縮モード: None, RangeCoder, FastLZ, zlib, Zstd | E-03 (47-53行目: CompressionMode) | ○ |
| C-09 | DTLS暗号化サポート | E-04 (276-303行目: dtls_*_setup) | ○ |
| C-10 | refuse_new_connections機能 | E-04 (286-293行目) | ○ |
| C-11 | poll()でイベントループ処理 | E-02 (164-259行目) | ○ |
| C-12 | peer_connectedシグナル発行 | E-02 (182, 213, 126行目) | ○ |
| C-13 | peer_disconnectedシグナル発行 | E-02 (160, 186, 220, 250行目) | ○ |
| C-14 | 転送モード: RELIABLE, UNRELIABLE, UNRELIABLE_ORDERED | E-02 (344-356行目) | ○ |
| C-15 | ENetConnectionでホスト作成 | E-04 (45-67, 69-71行目) | ○ |
| C-16 | connect_to_hostでピア接続 | E-04 (83-119行目) | ○ |
| C-17 | イベント種別: ERROR, NONE, CONNECT, DISCONNECT, RECEIVE | E-03 (62-68行目) | ○ |
| C-18 | ピア状態管理（10種類の状態） | E-05 (67-78行目: PeerState) | ○ |
| C-19 | ピア統計情報取得（14種類） | E-05 (80-95行目: PeerStatistic) | ○ |
| C-20 | IPv6サポート（GODOT_ENET使用時） | E-04 (53-57行目: ifdef GODOT_ENET) | ○ |
| C-21 | 帯域幅制限機能 | E-04 (205-208行目: bandwidth_limit) | ○ |
| C-22 | パケットフラグ: RELIABLE, UNSEQUENCED, UNRELIABLE_FRAGMENT | E-05 (61-65行目) | ○ |
| C-23 | 実行インスタンスダイアログとの関連 | E-07 (96行目: 画面39) | ○ |
| C-24 | パフォーマンス要件の具体的な数値保証 | **根拠なし** | △ |
| C-25 | DTLS暗号化の詳細アルゴリズム仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（同時接続数、スループット）の公式保証値
  - 候補：ENet公式ドキュメント / Godot公式ドキュメント / ベンチマークテスト
- DTLS実装の詳細（使用する暗号アルゴリズム、証明書要件）
  - 候補：TLSOptionsクラスの実装 / 暗号化関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、API仕様（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（実測値の確認推奨）
- 1: 中リスク - セキュリティ仕様（DTLS詳細の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] ENetMultiplayerPeerの3モード（Server/Client/Mesh）の動作確認
- [ ] パケット送受信の転送モード（Reliable/Unreliable/UnreliableOrdered）検証
- [ ] 接続/切断イベントのシグナル発行確認
- [ ] DTLS暗号化の実際の動作確認（セキュリティ要件がある場合）
- [ ] 最大接続数（4095）の実環境テスト
