---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-GDScript

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **コード補完のレスポンス時間目標値**：ベンチマーク確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/gdscript/gdscript.h` - GDScriptクラス定義
- E-02: `modules/gdscript/gdscript.cpp` - GDScript実装
- E-03: `modules/gdscript/gdscript_parser.h` - パーサー/ASTノード定義
- E-04: `modules/gdscript/gdscript_tokenizer.h` - トークナイザ定義
- E-05: `modules/gdscript/gdscript_compiler.h` - コンパイラ定義
- E-06: `modules/gdscript/gdscript_analyzer.h` - アナライザ定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GDScriptはScriptクラスを継承 | E-01 (60行目: GDCLASS(GDScript, Script)) | ○ |
| C-02 | トークナイザ→パーサー→アナライザ→コンパイラのパイプライン | E-02 (31-39行目: include文), E-01-E-06 | ○ |
| C-03 | Token::Type enumで約100種類のトークン定義 | E-04 (49-164行目) | ○ |
| C-04 | ASTノードとしてClassNode, FunctionNode等を定義 | E-03 (59-99行目: forward declarations) | ○ |
| C-05 | DataType classで型情報を管理 | E-03 (101-259行目) | ○ |
| C-06 | 型の種類: BUILTIN, NATIVE, SCRIPT, CLASS, ENUM, VARIANT | E-03 (105-114行目: Kind enum) | ○ |
| C-07 | 演算子優先順位はPrecedence enumで定義 | E-03 (1421-1446行目) | ○ |
| C-08 | GDScriptCompilerがバイトコード生成 | E-05 (40-186行目) | ○ |
| C-09 | CodeGen構造体でコンパイル時コンテキスト管理 | E-05 (74-142行目) | ○ |
| C-10 | @toolアノテーションでエディタ内実行 | E-01 (62行目: tool変数), E-01 (272行目: is_tool()) | ○ |
| C-11 | @abstractアノテーションで抽象クラス | E-01 (65行目: _is_abstract), E-01 (273行目: is_abstract()) | ○ |
| C-12 | member_functionsハッシュマップで関数管理 | E-01 (107行目) | ○ |
| C-13 | subclassesハッシュマップで内部クラス管理 | E-01 (108行目) | ○ |
| C-14 | _signalsハッシュマップでシグナル管理 | E-01 (109行目) | ○ |
| C-15 | rpc_configでRPC設定管理 | E-01 (110行目) | ○ |
| C-16 | GDScriptLanguageはScriptLanguageを継承 | E-01 (411行目: GDCLASS的な定義) | ○ |
| C-17 | スタックオーバーフロー検出機能 | E-01 (490-491行目: _debug_max_call_stack) | ○ |
| C-18 | プロファイリング機能 | E-01 (642-648行目: profiling_*メソッド) | ○ |
| C-19 | デバッガー連携機能 | E-01 (619-630行目: debug_*メソッド) | ○ |
| C-20 | ResourceFormatLoaderGDScriptでファイル読み込み | E-01 (668-678行目) | ○ |
| C-21 | ResourceFormatSaverGDScriptでファイル保存 | E-01 (680-687行目) | ○ |
| C-22 | GDScriptInstanceでスクリプトインスタンス管理 | E-01 (352-409行目) | ○ |
| C-23 | 継承チェーン: baseポインタで基底クラス参照 | E-01 (95行目: Ref<GDScript> base) | ○ |
| C-24 | nativeで組み込みクラス参照 | E-01 (94行目: Ref<GDScriptNativeClass> native) | ○ |
| C-25 | スクリプトエディタとの関連 | E-07 (21行目: 画面5) | ○ |
| C-26 | デバッガとの関連 | E-07 (48行目: 画面15) | ○ |
| C-27 | スクリプト作成ダイアログとの関連 | E-07 (80行目: 画面30) | ○ |
| C-28 | コード補完レスポンス時間<100ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- コード補完のレスポンス時間目標値
  - 候補：パフォーマンステスト結果 / 公式ドキュメント / ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語仕様、AST構造、コンパイルパイプライン（ソースコードで確認済み）
- 0: 低リスク - 画面との関連性（CSVで確認済み）
- 1: 中リスク - パフォーマンス要件（実測値の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] GDScriptのコンパイルパイプライン（Tokenizer→Parser→Analyzer→Compiler）動作確認
- [ ] 型推論と静的型付けの動作確認
- [ ] @toolアノテーションによるエディタ内実行確認
- [ ] デバッガー連携（ブレークポイント、変数監視）確認
- [ ] Language Server Protocol機能の動作確認
- [ ] ホットリロード機能の動作確認
