---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：43-C#サポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **AOTコンパイルの詳細仕様**：iOS/Web向けの具体的な制限事項確認推奨
  2. **NuGetパッケージサポートの範囲**：互換性情報の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/mono/csharp_script.h` - CSharpScript/Instance/Language定義
- E-02: `modules/mono/mono_gd/gd_mono.h` - GDMono定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpScriptはScriptを継承 | E-01 (58-59行目: GDCLASS(CSharpScript, Script)) | ○ |
| C-02 | TypeInfo構造体でC#クラス情報管理 | E-01 (65-126行目) | ○ |
| C-03 | class_nameでC#クラス名を保持 | E-01 (69行目) | ○ |
| C-04 | native_base_nameで継承元ネイティブクラス名 | E-01 (74行目) | ○ |
| C-05 | is_toolでエディタ実行フラグ | E-01 (84行目) | ○ |
| C-06 | is_global_classでグローバルクラス登録 | E-01 (91行目) | ○ |
| C-07 | is_abstractで抽象クラスフラグ | E-01 (96行目) | ○ |
| C-08 | ジェネリクス対応（constructed/definition） | E-01 (102-108行目) | ○ |
| C-09 | base_scriptで基底スクリプト参照 | E-01 (150行目) | ○ |
| C-10 | GD_MONO_HOT_RELOADでホットリロード対応 | E-01 (154-168行目) | ○ |
| C-11 | rpc_configでRPC設定 | E-01 (177行目) | ○ |
| C-12 | event_signalsでイベントシグナル管理 | E-01 (189行目) | ○ |
| C-13 | CSharpInstanceでマネージドオブジェクト管理 | E-01 (307-386行目) | ○ |
| C-14 | MonoGCHandleDataでGCハンドル保持 | E-01 (319行目) | ○ |
| C-15 | CSharpLanguageはScriptLanguageを継承 | E-01 (401行目) | ○ |
| C-16 | GDMonoシングルトンでランタイム管理 | E-01 (410行目), E-02 (92行目) | ○ |
| C-17 | hostfxr/coreclr DLLハンドル管理 | E-02 (65-66行目) | ○ |
| C-18 | project_assembly_path管理 | E-02 (68行目) | ○ |
| C-19 | プロジェクトロード失敗カウント | E-02 (71行目: project_load_failure_count) | ○ |
| C-20 | APIハッシュ検証（api_core_hash, api_editor_hash） | E-02 (80-84行目) | ○ |
| C-21 | PluginCallbacksでプラグイン管理 | E-02 (48-56行目) | ○ |
| C-22 | reload_project_assemblies()でリロード | E-02 (153行目) | ○ |
| C-23 | スクリプトエディタとの関連 | E-03 (21行目: 画面5) | ○ |
| C-24 | スクリプト作成ダイアログとの関連 | E-03 (80行目: 画面30) | ○ |
| C-25 | AOTコンパイルの詳細仕様 | **根拠なし** | △ |
| C-26 | NuGetパッケージサポートの範囲 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AOTコンパイル（iOS/Web）の詳細仕様
  - 候補：公式ドキュメント / エクスポート設定コード / プラットフォーム固有コード
- NuGetパッケージの互換性情報
  - 候補：.csprojテンプレート / ビルドスクリプト / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造、TypeInfo、GCハンドル管理（ソースコードで確認済み）
- 0: 低リスク - 画面との関連性（CSVで確認済み）
- 1: 中リスク - AOT/NuGet対応（公式ドキュメント確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] CSharpScriptの作成からインスタンス化までの動作確認
- [ ] [Export]属性によるプロパティ公開の確認
- [ ] [Signal]属性によるシグナル定義の確認
- [ ] [Tool]属性によるエディタ内実行確認
- [ ] ホットリロード機能の動作確認
- [ ] GCハンドル管理（メモリリーク確認）
- [ ] 外部エディタ（Visual Studio/Rider）連携確認
