---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：44-GDExtension

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **ネイティブコードの性能比較**：ベンチマーク確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `core/extension/gdextension.h` - GDExtensionクラス定義
- E-02: `core/extension/gdextension_manager.h` - GDExtensionManager定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GDExtensionはResourceを継承 | E-01 (41-42行目: GDCLASS(GDExtension, Resource)) | ○ |
| C-02 | Extension構造体でクラス情報管理 | E-01 (50-64行目) | ○ |
| C-03 | extension_classesハッシュマップ | E-01 (66行目) | ○ |
| C-04 | reloadableフラグでホットリロード制御 | E-01 (48行目) | ○ |
| C-05 | _register_extension_class5が最新API | E-01 (86行目) | ○ |
| C-06 | _register_extension_class_method | E-01 (88行目) | ○ |
| C-07 | _register_extension_class_property | E-01 (91行目) | ○ |
| C-08 | _register_extension_class_signal | E-01 (95行目) | ○ |
| C-09 | InitializationLevel enum定義 | E-01 (143-148行目) | ○ |
| C-10 | CORE/SERVERS/SCENE/EDITORの4レベル | E-01 (144-147行目) | ○ |
| C-11 | open_library/close_library | E-01 (139-140行目) | ○ |
| C-12 | initialize_library/deinitialize_library | E-01 (172-173行目) | ○ |
| C-13 | GDExtensionResourceLoaderクラス | E-01 (185-198行目) | ○ |
| C-14 | GDExtensionEditorPluginsクラス | E-01 (201-221行目) | ○ |
| C-15 | GDExtensionManagerはObjectを継承 | E-02 (38-39行目) | ○ |
| C-16 | LoadStatus enum | E-02 (53-59行目) | ○ |
| C-17 | LOAD_STATUS_OK/FAILED/ALREADY_LOADED/NOT_LOADED/NEEDS_RESTART | E-02 (54-58行目) | ○ |
| C-18 | load_extension/reload_extension/unload_extension | E-02 (71-75行目) | ○ |
| C-19 | get_loaded_extensions | E-02 (77行目) | ○ |
| C-20 | initialize_extensions/deinitialize_extensions | E-02 (83-84行目) | ○ |
| C-21 | startup/shutdown/frame | E-02 (97-99行目) | ○ |
| C-22 | gdextension_map管理 | E-02 (42行目) | ○ |
| C-23 | シングルトンパターン | E-02 (50, 91行目) | ○ |
| C-24 | ネイティブコードはGDScript比で数倍〜数十倍高速 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ネイティブコードとGDScriptの性能比較
  - 候補：公式ベンチマーク / パフォーマンステスト / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造、初期化レベル、API定義（ソースコードで確認済み）
- 0: 低リスク - ロード/アンロード処理（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス比較（実測値確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] .gdextensionファイルの読み込みと解析動作確認
- [ ] ネイティブライブラリのロード/アンロード確認
- [ ] クラス/メソッド/プロパティ/シグナル登録確認
- [ ] InitializationLevel順序（CORE→SERVERS→SCENE→EDITOR）確認
- [ ] ホットリロード機能の動作確認（reloadable=true時）
- [ ] エラーハンドリング（LoadStatus各値）確認
