---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：45-シーンエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **UI応答60fps維持**：パフォーマンス目標値の公式確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/editor_node.h` - EditorNodeクラス定義
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditorNodeはNodeを継承 | E-01 (118-119行目: GDCLASS(EditorNode, Node)) | ○ |
| C-02 | シングルトンパターン | E-01 (255行目: static EditorNode *singleton) | ○ |
| C-03 | MenuOptions enumでメニュー項目定義 | E-01 (141-225行目) | ○ |
| C-04 | Scene menu: 新規/開く/保存/閉じる | E-01 (143-161行目) | ○ |
| C-05 | Project menu: 設定/エクスポート | E-01 (165-179行目) | ○ |
| C-06 | Editor menu: 設定/レイアウト | E-01 (184-198行目) | ○ |
| C-07 | Help menu | E-01 (199-209行目) | ○ |
| C-08 | SceneNameCasing enum | E-01 (122-128行目) | ○ |
| C-09 | ActionOnPlay/ActionOnStop enum | E-01 (130-139行目) | ○ |
| C-10 | EditorData管理 | E-01 (257行目) | ○ |
| C-11 | EditorFolding管理 | E-01 (258行目) | ○ |
| C-12 | EditorSelectionHistory管理 | E-01 (259行目) | ○ |
| C-13 | DockSplitContainer群でレイアウト | E-01 (301-306行目) | ○ |
| C-14 | EditorSceneTabsでシーンタブ管理 | E-01 (309行目) | ○ |
| C-15 | editor_pluginsベクターでプラグイン管理 | E-01 (280行目) | ○ |
| C-16 | addon_name_to_pluginハッシュマップ | E-01 (282行目) | ○ |
| C-17 | EditorMainScreen管理 | E-01 (411行目) | ○ |
| C-18 | EditorDockManager管理 | E-01 (424行目) | ○ |
| C-19 | EditorBottomPanel管理 | E-01 (430行目) | ○ |
| C-20 | scene_root（編集中シーンルート） | E-01 (460行目) | ○ |
| C-21 | recent_scenesメニュー | E-01 (368行目) | ○ |
| C-22 | EditorProgress構造体 | E-01 (109-116行目) | ○ |
| C-23 | ExportDefer構造体 | E-01 (245-253行目) | ○ |
| C-24 | TOOLS_ENABLEDマクロでエディタコード制御 | E-01 (43行目等: #ifdef TOOLS_ENABLED) | ○ |
| C-25 | UI応答60fps維持 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- UI応答の具体的なパフォーマンス目標値
  - 候補：公式ドキュメント / パフォーマンステスト / 設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造、メニュー構成、UI要素（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（公式確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] EditorNode初期化フローの確認
- [ ] メニュー操作（Scene/Project/Editor/Help）の動作確認
- [ ] シーンの新規作成/開く/保存/閉じる動作確認
- [ ] ドックレイアウトの保存/復元確認
- [ ] プラグイン有効化/無効化の確認
- [ ] プロジェクト実行/デバッグの確認
- [ ] エクスポート機能の確認
