---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：46-スクリプトエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **コード補完<100ms応答**：パフォーマンス目標値の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/script/script_editor_plugin.h` - ScriptEditor/Base/Highlighter定義
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ScriptEditorはPanelContainerを継承 | E-01 (255-256行目: GDCLASS(ScriptEditor, PanelContainer)) | ○ |
| C-02 | MenuOptions enumでメニュー項目定義 | E-01 (258-309行目) | ○ |
| C-03 | File menu: 新規/開く/保存/閉じる | E-01 (260-284行目) | ○ |
| C-04 | Search menu: 検索/置換 | E-01 (294-300行目) | ○ |
| C-05 | Theme menu: インポート/リロード/保存 | E-01 (305-308行目) | ○ |
| C-06 | ScriptSortBy enum（名前/パス/なし） | E-01 (311-315行目) | ○ |
| C-07 | ScriptListName enum（名前/パス表示） | E-01 (317-321行目) | ○ |
| C-08 | EditorSyntaxHighlighter基底クラス | E-01 (53-74行目) | ○ |
| C-09 | EditorStandardSyntaxHighlighter | E-01 (76-94行目) | ○ |
| C-10 | EditorPlainTextSyntaxHighlighter | E-01 (96-103行目) | ○ |
| C-11 | EditorJSONSyntaxHighlighter | E-01 (105-121行目) | ○ |
| C-12 | EditorMarkdownSyntaxHighlighter | E-01 (123-139行目) | ○ |
| C-13 | EditorConfigFileSyntaxHighlighter | E-01 (141-161行目) | ○ |
| C-14 | ScriptEditorBase抽象基底クラス | E-01 (191-247行目) | ○ |
| C-15 | apply_code()メソッド | E-01 (206行目) | ○ |
| C-16 | get_breakpoints()/set_breakpoint() | E-01 (228-229行目) | ○ |
| C-17 | goto_line()メソッド | E-01 (218行目) | ○ |
| C-18 | script_list（スクリプト一覧） | E-01 (340行目) | ○ |
| C-19 | members_overview（メンバー一覧） | E-01 (342行目) | ○ |
| C-20 | tab_container（タブコンテナ） | E-01 (353行目) | ○ |
| C-21 | find_replace_bar | E-01 (358行目) | ○ |
| C-22 | zoom_factor（ズーム係数） | E-01 (360行目) | ○ |
| C-23 | autosave_timer（自動保存タイマー） | E-01 (329行目) | ○ |
| C-24 | コード補完<100ms応答 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- コード補完のレスポンス時間目標値
  - 候補：パフォーマンステスト / 公式ドキュメント / エディタ設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造、メニュー構成、構文ハイライター（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（実測確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] スクリプトの新規作成/開く/保存/閉じる動作確認
- [ ] 構文ハイライト（GDScript/JSON/Markdown/ConfigFile）確認
- [ ] コード補完の動作確認
- [ ] 検索/置換（ファイル内/プロジェクト全体）確認
- [ ] ブレークポイント設定/解除確認
- [ ] 外部変更検知とリロード確認
- [ ] 自動保存機能確認
