---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：47-アニメーションエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **タイムライン描画60fps維持**：パフォーマンス目標値の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/animation/animation_track_editor.h` - AnimationTrackEditor定義
- E-02: アニメーション関連ファイル一覧（Globで取得）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationTrackKeyEditクラス存在 | E-01 (58-93行目) | ○ |
| C-02 | AnimationMultiTrackKeyEditクラス | E-01 (95-131行目) | ○ |
| C-03 | AnimationMarkerKeyEditクラス | E-01 (133-159行目) | ○ |
| C-04 | AnimationTimelineEditはRangeを継承 | E-01 (185-186行目) | ○ |
| C-05 | ズーム係数定数（SCROLL_ZOOM_FACTOR_IN/OUT） | E-01 (192-193行目) | ○ |
| C-06 | animation_track_editor.hファイル存在 | E-02 | ○ |
| C-07 | animation_bezier_editor.hファイル存在 | E-02 | ○ |
| C-08 | animation_player_editor_plugin.hファイル存在 | E-02 | ○ |
| C-09 | animation_tree_editor_plugin.hファイル存在 | E-02 | ○ |
| C-10 | animation_blend_space_1d_editor.hファイル存在 | E-02 | ○ |
| C-11 | animation_blend_space_2d_editor.hファイル存在 | E-02 | ○ |
| C-12 | animation_state_machine_editor.hファイル存在 | E-02 | ○ |
| C-13 | animation_library_editor.hファイル存在 | E-02 | ○ |
| C-14 | animation_track_editor_plugins.hファイル存在 | E-02 | ○ |
| C-15 | read_onlyフラグでエディット可否制御 | E-01 (63行目, 196行目) | ○ |
| C-16 | use_fpsフラグで秒/フレーム切替 | E-01 (72行目, 110行目, 141行目) | ○ |
| C-17 | AnimationTrackEditorへの参照 | E-01 (73行目, 111行目, 199行目) | ○ |
| C-18 | タイムライン描画60fps維持 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- タイムライン描画のパフォーマンス目標値
  - 候補：パフォーマンステスト / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造、ファイル存在（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（実測確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] アニメーショントラック作成/削除の動作確認
- [ ] キーフレーム挿入/編集/削除の動作確認
- [ ] ベジエカーブ編集の動作確認
- [ ] タイムラインのズーム/スクロール動作確認
- [ ] FPS/秒表示切替の動作確認
- [ ] AnimationTree連携の動作確認
