---
generated_at: 2026-01-23 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-ファイルシステムドック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/docks/filesystem_dock.h` - FileSystemDock定義
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileSystemDockはEditorDockを継承 | E-01 (87-88行目: GDCLASS(FileSystemDock, EditorDock)) | ○ |
| C-02 | FileListDisplayMode enum（THUMBNAILS/LIST） | E-01 (91-94行目) | ○ |
| C-03 | DisplayMode enum（TREE_ONLY/VSPLIT/HSPLIT） | E-01 (96-100行目) | ○ |
| C-04 | Overwrite enum | E-01 (102-106行目) | ○ |
| C-05 | FileMenu enum定義 | E-01 (109-145行目) | ○ |
| C-06 | FILE_MENU_OPEN〜FILE_MENU_MAX | E-01 (110-139行目) | ○ |
| C-07 | folder_mapハッシュマップ | E-01 (147行目) | ○ |
| C-08 | folder_colorsハッシュマップ | E-01 (148行目) | ○ |
| C-09 | favoritesハッシュセット | E-01 (163行目) | ○ |
| C-10 | file_list_display_mode変数 | E-01 (184行目) | ○ |
| C-11 | display_mode変数 | E-01 (185行目) | ○ |
| C-12 | file_list_popup（コンテキストメニュー） | E-01 (190行目) | ○ |
| C-13 | tree_popup（コンテキストメニュー） | E-01 (191行目) | ○ |
| C-14 | deps_editor（依存関係エディタ） | E-01 (193行目) | ○ |
| C-15 | owners_editor（オーナーエディタ） | E-01 (194行目) | ○ |
| C-16 | remove_dialog（削除ダイアログ） | E-01 (195行目) | ○ |
| C-17 | move_dialog（移動ダイアログ） | E-01 (197行目) | ○ |
| C-18 | make_dir_dialog（フォルダ作成ダイアログ） | E-01 (198行目) | ○ |
| C-19 | overwrite_dialog（上書き確認ダイアログ） | E-01 (200行目) | ○ |
| C-20 | FileSystemTree/FileSystemListクラス | E-01 (61-85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ツリービュー/リストビュー切替の動作確認
- [ ] ファイル/フォルダの作成/削除/移動/名前変更確認
- [ ] お気に入り追加/削除の動作確認
- [ ] 検索/フィルタ機能の動作確認
- [ ] コンテキストメニュー各項目の動作確認
- [ ] ドラッグ＆ドロップの動作確認
