---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-インスペクター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/inspector/editor_inspector.h` - EditorInspector/Property定義
- E-02: Globで取得したinspectorディレクトリファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditorPropertyRevertクラス存在 | E-01 (52-56行目) | ○ |
| C-02 | EditorPropertyはContainerを継承 | E-01 (70-71行目: GDCLASS(EditorProperty, Container)) | ○ |
| C-03 | ThemeCache構造体 | E-01 (75-116行目) | ○ |
| C-04 | MenuItems enum定義 | E-01 (119-129行目) | ○ |
| C-05 | MENU_COPY_VALUE〜MENU_OPEN_DOCUMENTATION | E-01 (120-128行目) | ○ |
| C-06 | ColorationMode enum | E-01 (131-135行目) | ○ |
| C-07 | InlineControlSide enum | E-01 (137-140行目) | ○ |
| C-08 | read_onlyフラグ | E-01 (157行目) | ○ |
| C-09 | checkableフラグ | E-01 (158行目) | ○ |
| C-10 | keyingフラグ | E-01 (162行目) | ○ |
| C-11 | deletableフラグ | E-01 (163行目) | ○ |
| C-12 | can_revertフラグ | E-01 (178行目) | ○ |
| C-13 | can_pinフラグ | E-01 (179行目) | ○ |
| C-14 | pinnedフラグ | E-01 (181行目) | ○ |
| C-15 | can_favoriteフラグ | E-01 (183行目) | ○ |
| C-16 | favoritedフラグ | E-01 (184行目) | ○ |
| C-17 | sub_inspector_color_level変数 | E-01 (189行目) | ○ |
| C-18 | editor_inspector.hファイル存在 | E-02 | ○ |
| C-19 | editor_properties.hファイル存在 | E-02 | ○ |
| C-20 | editor_properties_array_dict.hファイル存在 | E-02 | ○ |
| C-21 | editor_properties_vector.hファイル存在 | E-02 | ○ |
| C-22 | editor_resource_picker.hファイル存在 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各種プロパティタイプ（数値、文字列、ベクトル、色等）の編集確認
- [ ] リバート機能の動作確認
- [ ] お気に入り登録/解除の確認
- [ ] コピー/ペースト機能の確認
- [ ] サブリソース編集の確認
- [ ] マルチノード編集の確認
- [ ] アニメーションキーイング機能の確認
