---
generated_at: 2026-01-23 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-デバッガー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/debugger/editor_debugger_node.h` - EditorDebuggerNode定義
- E-02: Globで取得したdebuggerディレクトリファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditorDebuggerNodeはEditorDockを継承 | E-01 (47-48行目: GDCLASS(EditorDebuggerNode, EditorDock)) | ○ |
| C-02 | CameraOverride enum（NONE/INGAME/EDITORS） | E-01 (51-55行目) | ○ |
| C-03 | Options enum（DEBUG_NEXT/STEP/BREAK/CONTINUE） | E-01 (58-64行目) | ○ |
| C-04 | Breakpoint構造体（source, line） | E-01 (66-92行目) | ○ |
| C-05 | EditorDebuggerServerへの参照 | E-01 (94行目) | ○ |
| C-06 | tabsメンバー変数 | E-01 (95行目) | ○ |
| C-07 | last_error_count変数 | E-01 (101行目) | ○ |
| C-08 | last_warning_count変数 | E-01 (102行目) | ○ |
| C-09 | remote_scene_tree変数 | E-01 (106行目) | ○ |
| C-10 | debug_with_external_editor変数 | E-01 (111行目) | ○ |
| C-11 | debug_mute_audio変数 | E-01 (115行目) | ○ |
| C-12 | camera_override変数 | E-01 (117行目) | ○ |
| C-13 | breakpointsハッシュマップ | E-01 (118行目) | ○ |
| C-14 | debugger_pluginsハッシュセット | E-01 (120行目) | ○ |
| C-15 | シングルトンパターン | E-01 (128行目: static EditorDebuggerNode *singleton) | ○ |
| C-16 | debug_next()メソッド | E-01 (176行目) | ○ |
| C-17 | debug_step()メソッド | E-01 (177行目) | ○ |
| C-18 | debug_break()メソッド | E-01 (178行目) | ○ |
| C-19 | debug_continue()メソッド | E-01 (179行目) | ○ |
| C-20 | set_breakpoint()メソッド | E-01 (190行目) | ○ |
| C-21 | request_remote_tree()メソッド | E-01 (196行目) | ○ |
| C-22 | set_remote_selection()メソッド | E-01 (197行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ブレークポイント設定/解除の動作確認
- [ ] 実行停止/続行/ステップ実行の動作確認
- [ ] 変数監視の動作確認
- [ ] スタックトレース表示の確認
- [ ] リモートシーンツリー操作の確認
- [ ] エラー/警告ログの確認
- [ ] カメラオーバーライド機能の確認
- [ ] 複数デバッグセッション管理の確認
