---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-Windows対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **セキュリティ考慮事項の網羅性**：追加検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `platform/windows/export/export_plugin.cpp` - export_project関数（203-367行目）
- E-02: `platform/windows/export/export_plugin.cpp` - _process_icon関数（72-182行目）
- E-03: `platform/windows/export/export_plugin.cpp` - _code_sign関数（543-714行目）
- E-04: `platform/windows/export/export_plugin.cpp` - fixup_embedded_pck関数（806-917行目）
- E-05: `platform/windows/export/export_plugin.cpp` - get_export_options関数（454-506行目）
- E-06: `platform/windows/export/export_plugin.cpp` - has_valid_export_configuration関数（716-742行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.23との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アーキテクチャはx86_64/x86_32/arm64から選択可能 | E-05（457行目） | ○ |
| C-02 | エクスポートテンプレートの検証を行う | E-06 | ○ |
| C-03 | ANGLE/D3D12ライブラリのコピー処理がある | E-01（250-298行目） | ○ |
| C-04 | PCK埋め込みオプションがある | E-01（221,302-326行目） | ○ |
| C-05 | コード署名機能がある（signtool/osslsigncode） | E-03 | ○ |
| C-06 | SSHリモートデプロイ機能がある | E-05（498-505行目）、E-01（987-1131行目） | ○ |
| C-07 | アイコンは複数サイズで生成される（16,32,48,64,128,256） | E-02（73行目） | ○ |
| C-08 | バージョン形式はX.X.X.X（4つの整数） | E-05（388-406行目） | ○ |
| C-09 | 実行ファイルサイズ制限4GiB | E-04（809-811行目） | ○ |
| C-10 | PEヘッダのマジックナンバー検証 | E-04（827-829行目） | ○ |
| C-11 | pckセクションの検索と更新処理 | E-04（857-904行目） | ○ |
| C-12 | ZIPアーカイブ出力をサポート | E-01（220,329-346行目） | ○ |
| C-13 | アイコンキャッシュ更新（SHChangeNotify） | E-01（350-362行目） | ○ |
| C-14 | カスタムテンプレートのアーキテクチャ整合性チェック | E-01（213-217行目）、E-06（724-735行目） | ○ |
| C-15 | タイムスタンプサーバーURL必須 | E-03（615-633行目） | ○ |
| C-16 | 証明書パスワードは環境変数からも取得可能 | E-03（605-612行目） | ○ |
| C-17 | Windows以外ではosslsigncodeを使用 | E-03（556-563行目） | ○ |
| C-18 | osslsigncodeはidentity_typeオプション非対応 | E-05（418-420行目）、E-03（594行目） | ○ |
| C-19 | コンソールラッパーも生成される | E-01（195-198行目,314-317行目） | ○ |
| C-20 | AccessKitライブラリのコピー | E-01（266-268行目） | ○ |
| C-21 | 出力形式は.exeと.zip | E-01（373-378行目） | ○ |
| C-22 | エクスポートダイアログ（画面No.23）との関連 | E-07 | ○ |
| C-23 | 関連するソースファイル一覧の正確性 | E-01〜E-06 | ○ |
| C-24 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-25 | セキュリティ考慮事項の網羅性 | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：PCK生成時間やコード署名時間の具体的なベンチマーク情報がソースコード内に存在しない
  - 候補：実測値の取得 / ベンチマークテストの実施 / ドキュメント参照
- セキュリティ考慮事項：証明書管理のベストプラクティスやSSH鍵管理に関する詳細情報
  - 候補：公式ドキュメント / セキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なエクスポート処理フローは十分に根拠あり
- 1: 中リスク - パフォーマンス要件は一般論としての記載にとどまる
- 1: 中リスク - セキュリティ考慮事項は主要な点のみカバー

## 6) レビュアーチェックリスト（最小）
- [ ] エクスポートオプション一覧がget_export_options関数と一致しているか
- [ ] エラーコードがソースコード内のERR_FAIL_COND等と一致しているか
- [ ] 処理フローがexport_project関数の実装順序と一致しているか
- [ ] コード署名処理のWindows/非Windows分岐が正確か
