---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：52-macOS対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **公証処理の具体的なタイムアウト値**：根拠不足
  2. **PKG作成の詳細なコマンドライン**：部分的根拠

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `platform/macos/export/export_plugin.cpp` - get_export_options関数（465-617行目）
- E-02: `platform/macos/export/export_plugin.cpp` - get_export_option_warning関数（77-265行目）
- E-03: `platform/macos/export/export_plugin.cpp` - get_binary_extensions関数（386-411行目）
- E-04: `platform/macos/export/export_plugin.cpp` - get_preset_features関数（52-75行目）
- E-05: `platform/macos/export/export_plugin.cpp` - _make_icon関数（668-700行目）
- E-06: `platform/macos/export/export_plugin.cpp` - get_export_option_visibility関数（267-384行目）
- E-07: `editor/export/codesign.cpp` - コード署名処理
- E-08: `editor/export/lipo.cpp` - バイナリ結合処理
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.23との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アーキテクチャはuniversal/x86_64/arm64から選択可能 | E-01（472行目） | ○ |
| C-02 | 配布タイプはTesting/Distribution/App Storeの3種 | E-01（467-470行目） | ○ |
| C-03 | DMG作成はmacOS環境でのみ可能 | E-03（392-394行目） | ○ |
| C-04 | PKG作成はmacOS環境でApp Store配布時のみ | E-03（403-407行目） | ○ |
| C-05 | 署名ツールはDisabled/ad-hoc/rcodesign/codesignの4種 | E-01（504-508行目） | ○ |
| C-06 | App Storeではサンドボックスが必須 | E-02（151-156行目） | ○ |
| C-07 | 公証にはTeam IDが必須 | E-02（126-135行目） | ○ |
| C-08 | ad-hoc署名では公証不可 | E-02（117-124行目） | ○ |
| C-09 | rcodesignはGDExtension埋め込みアプリの署名に非対応 | E-02（160-162行目） | ○ |
| C-10 | 権限有効時はプライバシー説明が必須 | E-02（219-262行目） | ○ |
| C-11 | アイコンは複数サイズで生成される | E-05（684-695行目） | ○ |
| C-12 | バンドル識別子の検証がある | E-02（99-105行目） | ○ |
| C-13 | universalバイナリはlipoで結合 | E-04（56-74行目）、E-08 | ○ |
| C-14 | 公証ツールはDisabled/rcodesign/notarytoolの3種 | E-01（547-550行目） | ○ |
| C-15 | Apple ID認証とAPI Key認証の2方式がある | E-02（179-217行目） | ○ |
| C-16 | SSH経由のリモートデプロイをサポート | E-01（609-616行目） | ○ |
| C-17 | Shader Bakerオプションがある | E-01（492行目）、E-04（66-69行目） | ○ |
| C-18 | プロビジョニングプロファイルはApp Store配布時必須 | E-02（137-142行目） | ○ |
| C-19 | インストーラ署名IDはApp Store配布時必須 | E-02（144-149行目） | ○ |
| C-20 | エンタイトルメントのカスタムファイル指定が可能 | E-01（519行目）、E-06（316-319行目） | ○ |
| C-21 | x86_64は最小macOS 10.12、arm64は最小11.00 | E-01（487-488行目） | ○ |
| C-22 | データ収集タイプのプライバシー設定がある | E-01（418-463行目,585-599行目） | ○ |
| C-23 | Liquid Glass IconはmacOS Tahoe以降で使用可能 | E-01（477行目）、E-06（311-314行目） | ○ |
| C-24 | .NET使用時はJIT/unsigned memory/dyld環境変数が必須 | E-06（371-376行目） | ○ |
| C-25 | ICNSはPNG形式とRLE形式の両方を含む | E-05（684-695行目） | ○ |
| C-26 | 関連ファイル一覧の正確性 | E-01〜E-09 | ○ |
| C-27 | 公証処理のタイムアウト仕様 | **根拠なし** | △ |
| C-28 | PKG作成のproductbuildコマンド詳細 | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- 公証処理のタイムアウト仕様：ソースコード内に明示的なタイムアウト値の定義が見つからない
  - 候補：実行時ログの確認 / Apple公式ドキュメント参照
- PKG作成の詳細：productbuildコマンドの具体的な引数構築部分の確認が必要
  - 候補：export_project関数の後半部分の詳細読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なエクスポートオプションと検証ロジックは十分に根拠あり
- 1: 中リスク - 公証処理の詳細な挙動は追加確認が必要
- 0: 低リスク - コード署名の分岐ロジックは明確に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 配布タイプによる出力形式の分岐がget_binary_extensions関数と一致しているか
- [ ] エンタイトルメントオプションがコード署名処理と整合しているか
- [ ] プライバシー使用説明の必須チェックロジックが正確か
- [ ] macOS/非macOS環境での機能差異が正確に記載されているか
