---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-Linux対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `platform/linuxbsd/export/export_plugin.cpp` - export_project関数（61-151行目）
- E-02: `platform/linuxbsd/export/export_plugin.cpp` - _get_exe_arch関数（255-293行目）
- E-03: `platform/linuxbsd/export/export_plugin.cpp` - _export_debug_script関数（46-59行目）
- E-04: `platform/linuxbsd/export/export_plugin.cpp` - get_export_options関数（185-207行目）
- E-05: `platform/linuxbsd/export/export_plugin.cpp` - get_binary_extensions関数（157-163行目）
- E-06: `platform/linuxbsd/export/export_plugin.cpp` - has_valid_export_configuration関数（227-253行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アーキテクチャはx86_64/x86_32/arm64/arm32/rv64/ppc64/loongarch64から選択可能 | E-04（188行目） | ○ |
| C-02 | カスタムテンプレートのアーキテクチャ整合性検証がある | E-01（68-73行目）、E-06（235-246行目） | ○ |
| C-03 | AccessKitライブラリのコピー処理がある | E-01（76-79行目） | ○ |
| C-04 | ZIP形式でのパッケージ作成をサポート | E-01（81,97-109,130-148行目）、E-05（160行目） | ○ |
| C-05 | コンソールラッパースクリプト（.sh）を生成できる | E-01（119-127行目）、E-03 | ○ |
| C-06 | ELFマジックナンバー（0x464c457f）で検証 | E-02（264行目） | ○ |
| C-07 | e_machine値でアーキテクチャを特定 | E-02（275-292行目） | ○ |
| C-08 | SSH経由のリモートデプロイをサポート | E-04（199-206行目） | ○ |
| C-09 | 出力ファイルの拡張子はアーキテクチャ名 | E-05（159行目） | ○ |
| C-10 | シェルスクリプトには実行権限0755を設定 | E-01（123行目） | ○ |
| C-11 | 一時フォルダを使用しZIP完了後に削除 | E-01（94,143-147行目） | ○ |
| C-12 | EditorExportPlatformPCを継承 | E-01（112行目）、E-04（186行目） | ○ |
| C-13 | is_elf関数でELF形式を判定 | E-02（209-214行目） | ○ |
| C-14 | is_shebang関数でスクリプトを判定 | E-02（216-221行目） | ○ |
| C-15 | コンソールラッパーオプションは3段階（No/Debug Only/Always） | E-01（119-120行目） | ○ |
| C-16 | テンプレートファイル名はlinux_{target}.{arch}形式 | E-01（153-155行目） | ○ |
| C-17 | fixup_embedded_pck関数でPCK埋め込み処理 | E-01（295行目以降） | ○ |
| C-18 | 関連ファイル一覧の正確性 | E-01〜E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] アーキテクチャ一覧がget_export_options関数と一致しているか
- [ ] ELFアーキテクチャ判定のe_machine値が正確か
- [ ] コンソールラッパースクリプトの内容が正確か
