---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：54-Android対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **Gradleビルドの詳細コマンド**：部分的根拠
  2. **C#/.NET非サポートの詳細条件**：追加確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `platform/android/export/export_plugin.cpp` - パーミッション定義（68-223行目）
- E-02: `platform/android/export/export_plugin.cpp` - ランチャーアイコン定義（247-281行目）
- E-03: `platform/android/export/export_plugin.cpp` - デフォルトSDKバージョン（289-290行目）
- E-04: `platform/android/export/export_plugin.cpp` - デバイス検出スレッド（293-479行目）
- E-05: `platform/android/export/export_plugin.cpp` - エクスポート形式定義（283-288行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポート形式はAPK（0）とAAB（1）の2種類 | E-05（283-284行目） | ○ |
| C-02 | デフォルトminSdkは24 | E-03（289行目） | ○ |
| C-03 | デフォルトtargetSdkは35 | E-03（290行目） | ○ |
| C-04 | ランチャーアイコンは6種類の密度に対応 | E-02（241,247-254行目） | ○ |
| C-05 | アダプティブアイコンはForeground/Background/Monochromeの3層 | E-02（256-281行目） | ○ |
| C-06 | パーミッションは200種類以上定義されている | E-01 | ○ |
| C-07 | ADBによるデバイス検出機能がある | E-04（324-346行目） | ○ |
| C-08 | APKアセットディレクトリはsrc/main/assets | E-05（286行目） | ○ |
| C-09 | AABアセットディレクトリはassetPackInstallTime/src/main/assets | E-05（287行目） | ○ |
| C-10 | GDExtensionライブラリのJSON管理 | E-05（227行目） | ○ |
| C-11 | アダプティブアイコンXMLテンプレートがある | E-02（230-236行目） | ○ |
| C-12 | バージョン不一致時はエラーメッセージを表示 | E-01（225行目） | ○ |
| C-13 | デバイス情報はgetpropで取得 | E-04（386-422行目） | ○ |
| C-14 | ADB終了時にkill-serverを実行（設定による） | E-04（449-458行目） | ○ |
| C-15 | エディタ準備完了までADB実行を遅延 | E-04（328行目） | ○ |
| C-16 | アイコンサイズはmdpi〜xxxhdpiの5段階 | E-02（247-254行目） | ○ |
| C-17 | アダプティブアイコンサイズは108〜432px | E-02（256-281行目） | ○ |
| C-18 | モノクロームアイコンはオプション | E-02（233-235行目） | ○ |
| C-19 | テーマ付きアイコンXMLパスが定義されている | E-02（239行目） | ○ |
| C-20 | 関連ファイル一覧の正確性 | E-01〜E-05 | ○ |
| C-21 | Gradleビルドの詳細なコマンドライン | **部分的根拠** | △ |
| C-22 | C#/.NET非サポートの詳細条件 | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- Gradleビルドの詳細：Gradle実行部分の具体的なコマンドライン構築の確認が必要
  - 候補：export_project関数の後半部分の詳細読解
- C#/.NET非サポート：MODULEマクロによる条件分岐の確認が必要
  - 候補：MODULE_MONO_ENABLED関連コードの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なエクスポートオプションとアイコン処理は十分に根拠あり
- 1: 中リスク - Gradleビルドの詳細実装は追加確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] パーミッション一覧がソースコードと一致しているか
- [ ] アイコンサイズがランチャーアイコン定義と一致しているか
- [ ] SDKバージョンのデフォルト値が正確か
- [ ] エクスポート形式の定数値が正確か
