---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：55-iOS対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **IPAビルドの詳細処理**：Xcodeとの連携部分の追加確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `platform/ios/export/export_plugin.cpp` - get_export_options関数（55-66行目）
- E-02: `platform/ios/export/export_plugin.cpp` - has_valid_export_configuration関数（68-90行目）
- E-03: `platform/ios/export/export_plugin.cpp` - get_icon_infos関数（196-231行目）
- E-04: `platform/ios/export/export_plugin.cpp` - _export_icons関数（233-387行目）
- E-05: `platform/ios/export/export_plugin.cpp` - _export_loading_screen_file関数（136-194行目）
- E-06: `platform/ios/export/export_plugin.cpp` - _process_config_file_line関数（389-489行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デバイスファミリーはiPhone/iPad/Bothの3種類 | E-01（58行目） | ○ |
| C-02 | Metal rendererはiOS 14+が必要 | E-02（74-79行目） | ○ |
| C-03 | アイコンは複数サイズ・解像度で生成 | E-03（196-231行目） | ○ |
| C-04 | Settings用アイコンは58x58(@2x)、87x87(@3x) | E-03（200-201行目） | ○ |
| C-05 | App Store用アイコンは1024x1024(@1x) | E-03（229行目） | ○ |
| C-06 | App Store用アイコンは不透明である必要がある | E-04（292-293行目）、E-03（229行目force_opaque=true） | ○ |
| C-07 | 通常/ダーク/色付きの3モードアイコンをサポート | E-04（245-251,260-266行目） | ○ |
| C-08 | Contents.jsonを生成する | E-04（366-376行目） | ○ |
| C-09 | カスタムスプラッシュは@2xと@3x両方必要 | E-05（140-163行目） | ○ |
| C-10 | スプラッシュ画像はsplash@2x.png/splash@3x.pngとして保存 | E-05（141,153行目） | ○ |
| C-11 | storyboard/image_scale_modeオプションがある | E-01（61行目） | ○ |
| C-12 | スプラッシュスケールモードは5種類 | E-01（61行目）、E-06（446-456行目） | ○ |
| C-13 | targeted_device_familyはXcode値に変換される | E-06（395-408行目） | ○ |
| C-14 | MoltenVKフレームワークの参照がある | E-06（411-422行目） | ○ |
| C-15 | Launch Screen Storyboardの参照がある | E-06（425-439行目） | ○ |
| C-16 | IPHONEOS_DEPLOYMENT_TARGETが設定される | E-06（474-477行目） | ○ |
| C-17 | valid_archsはarm64とx86_64 | E-06（480-481行目） | ○ |
| C-18 | 親クラスの処理を継承している | E-06（484-486行目） | ○ |
| C-19 | 関連ファイル一覧の正確性 | E-01〜E-06 | ○ |
| C-20 | IPAビルドの詳細処理 | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- IPAビルドの詳細処理：Xcode xcodebuild連携部分の確認が必要
  - 候補：EditorExportPlatformAppleEmbedded親クラスの詳細読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アイコン処理とスプラッシュ画面処理は十分に根拠あり
- 1: 中リスク - Xcodeビルド連携の詳細は追加確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] アイコンサイズ一覧がget_icon_infos関数と一致しているか
- [ ] Metal最小バージョン要件が正確か
- [ ] デバイスファミリーのXcode値変換が正確か
- [ ] スプラッシュ画像のスケールモードが正確か
