---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-Web（HTML5）対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `platform/web/export/export_plugin.cpp` - _extract_template関数（48-102行目）
- E-02: `platform/web/export/export_plugin.cpp` - _fix_html関数（132-191行目）
- E-03: `platform/web/export/export_plugin.cpp` - _build_pwa関数（226-343行目）
- E-04: `platform/web/export/export_plugin.cpp` - _add_manifest_icon関数（193-224行目）
- E-05: `platform/web/export/export_plugin.cpp` - get_export_options関数（367-394行目）
- E-06: `platform/web/export/export_plugin.cpp` - get_preset_features関数（345-365行目）
- E-07: `platform/web/export/export_plugin.cpp` - has_valid_export_configuration関数（421-460行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GDExtensionサポートオプションがある | E-05（371行目） | ○ |
| C-02 | スレッドサポートオプションがある | E-05（372行目） | ○ |
| C-03 | デスクトップ向けテクスチャ圧縮（S3TC/BPTC）オプションがある | E-05（373行目）、E-06（346-349行目） | ○ |
| C-04 | モバイル向けテクスチャ圧縮（ETC2/ASTC）オプションがある | E-05（374行目）、E-06（350-353行目） | ○ |
| C-05 | カスタムHTMLシェルオプションがある | E-05（377行目） | ○ |
| C-06 | HTMLヘッド追加コンテンツオプションがある | E-05（378行目） | ○ |
| C-07 | キャンバスリサイズポリシーは3種類（None/Project/Adaptive） | E-05（379行目） | ○ |
| C-08 | PWA有効化オプションがある | E-05（382行目） | ○ |
| C-09 | PWA表示モードは4種類（Fullscreen/Standalone/Minimal UI/Browser） | E-05（385行目）、E-03（302-303行目） | ○ |
| C-10 | PWA画面向きは3種類（Any/Landscape/Portrait） | E-05（386行目）、E-03（303行目） | ○ |
| C-11 | C#/.NET使用時はエラーメッセージを表示 | E-07（422-426行目） | ○ |
| C-12 | テンプレートはZIP形式から解凍 | E-01（51行目） | ○ |
| C-13 | Service WorkerとOfflineページはPWA有効時のみ | E-01（78-80行目） | ○ |
| C-14 | Engine.js configがJSON形式で生成される | E-02（133-155行目） | ○ |
| C-15 | スレッドサポート時はスレッドフラグが設定される | E-02（184-188行目）、E-06（354-358行目） | ○ |
| C-16 | PWAアイコンは144x144、180x180、512x512の3サイズ | E-03（315-328行目）、E-04（195行目） | ○ |
| C-17 | Manifestにはname、start_url、display、orientationが含まれる | E-03（307-311行目） | ○ |
| C-18 | Service WorkerにはキャッシュファイルリストとCOIヘッダ設定がある | E-03（236-269行目） | ○ |
| C-19 | wasm32がfeatureとして追加される | E-06（364行目） | ○ |
| C-20 | Cross-Origin Isolationヘッダオプションがある | E-05（383行目）、E-02（151行目） | ○ |
| C-21 | スレッドプールサイズオプションがある | E-05（392-393行目）、E-02（153-154行目） | ○ |
| C-22 | 関連ファイル一覧の正確性 | E-01〜E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] エクスポートオプション一覧がget_export_options関数と一致しているか
- [ ] PWA表示モードと画面向きの選択肢が正確か
- [ ] C#/.NET非対応のエラーメッセージが正確か
- [ ] Service Workerのキャッシュファイルリストが正確か
