---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-GridMap

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/gridmap/grid_map.cpp` - set_cell_item関数（350-427行目）
- E-02: `modules/gridmap/grid_map.cpp` - get_cell_item関数（429-443行目）
- E-03: `modules/gridmap/grid_map.cpp` - _ortho_bases配列（461-486行目）
- E-04: `modules/gridmap/grid_map.cpp` - get_octant_key_from_cell_coords関数（543-554行目）
- E-05: `modules/gridmap/grid_map.cpp` - local_to_map/map_to_local関数（556-568行目）
- E-06: `modules/gridmap/grid_map.cpp` - _octant_update関数（600-834行目）
- E-07: `modules/gridmap/grid_map.cpp` - set_cell_size関数（302-307行目）
- E-08: `modules/gridmap/grid_map.cpp` - collision_layer設定（162-196行目）
- E-09: `modules/gridmap/grid_map.cpp` - make_baked_meshes関数（1359-1439行目）
- E-10: `modules/gridmap/grid_map.cpp` - _get_offset関数（1342-1347行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セル座標は±2^20の範囲内 | E-01（357-359行目） | ○ |
| C-02 | アイテムID < 0でセル削除 | E-01（368-381行目） | ○ |
| C-03 | オクタントが存在しない場合は作成 | E-01（385-415行目） | ○ |
| C-04 | StaticBody3Dを物理ボディとして使用 | E-01（390-395行目） | ○ |
| C-05 | INVALID_CELL_ITEM = -1 | E-02（440行目） | ○ |
| C-06 | 24種類の直交回転をサポート | E-03（461-486行目） | ○ |
| C-07 | オクタント座標計算式 | E-04（544-546行目） | ○ |
| C-08 | local_to_map計算式 | E-05（557行目） | ○ |
| C-09 | map_to_local計算式 | E-05（562-567行目） | ○ |
| C-10 | dirty flagで変更追跡 | E-06（603-605行目） | ○ |
| C-11 | 物理シェイプクリア処理 | E-06（609行目） | ○ |
| C-12 | MultiMesh生成処理 | E-06（768-806行目） | ○ |
| C-13 | NavigationServer3D連携 | E-06（716-757行目） | ○ |
| C-14 | セルサイズのバリデーション（0.001以上） | E-07（303行目） | ○ |
| C-15 | コリジョンレイヤー1-32の範囲チェック | E-08（181-182行目） | ○ |
| C-16 | SurfaceToolでメッシュ追加 | E-09（1404-1411行目） | ○ |
| C-17 | ライトマップUV生成オプション | E-09（1432-1434行目） | ○ |
| C-18 | オフセット計算（center_x/y/z） | E-10（1343-1346行目） | ○ |
| C-19 | cell_size_changedシグナル | E-07（306行目） | ○ |
| C-20 | PhysicsMaterial連携 | E-01（396-399行目）、E-08（219-226行目） | ○ |
| C-21 | ナビゲーションベイク有効化オプション | E-06（724-755行目） | ○ |
| C-22 | 関連ファイル一覧の正確性 | E-01〜E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] セル座標範囲制限が正確か
- [ ] オクタント座標計算式が正確か
- [ ] 24種類の直交回転行列が正確か
- [ ] ベイクメッシュ生成処理が正確か
