---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 44
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート: 2Dレンダリング

## 1. 概要

本レポートは「6-2Dレンダリング.md」機能設計書の記述内容について、ソースコードに基づく根拠を提示する。

## 2. 主張と根拠の対応

### 2.1 クラス構造に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 1 | Sprite2DはNode2Dを継承 | `class Sprite2D : public Node2D` | sprite_2d.h 36行目 |
| 2 | CanvasItemはNodeを継承 | `class CanvasItem : public Node` | canvas_item.h 44行目 |
| 3 | Sprite2Dにtexture, centered, offset等のメンバがある | メンバ変数宣言 | sprite_2d.h 39-57行目 |
| 4 | CanvasItemにcanvas_item RIDがある | `RID canvas_item` | canvas_item.h 82行目 |
| 5 | CanvasItemにvisible, pending_update, drawingフラグがある | メンバ変数宣言 | canvas_item.h 106-111行目 |
| 6 | CanvasItemにglobal_transformキャッシュがある | `mutable Transform2D global_transform` | canvas_item.h 130行目 |

### 2.2 TextureFilter/TextureRepeat列挙型に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 7 | TEXTURE_FILTER_PARENT_NODE等の列挙値が存在 | enum TextureFilter定義 | canvas_item.h 52-61行目 |
| 8 | TEXTURE_REPEAT_PARENT_NODE等の列挙値が存在 | enum TextureRepeat定義 | canvas_item.h 63-69行目 |

### 2.3 queue_redraw()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 9 | ERR_THREAD_GUARDでスレッドチェック | `ERR_THREAD_GUARD;` | canvas_item.cpp 473行目 |
| 10 | is_inside_tree()で早期リターン | `if (!is_inside_tree()) return;` | canvas_item.cpp 474-476行目 |
| 11 | pending_updateで重複リクエスト防止 | `if (pending_update) return;` | canvas_item.cpp 477-479行目 |
| 12 | call_deferredで_redraw_callbackをスケジュール | `callable_mp(...).call_deferred()` | canvas_item.cpp 483行目 |

### 2.4 _redraw_callback()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 13 | canvas_item_clear()で描画コマンドクリア | `RenderingServer::get_singleton()->canvas_item_clear(...)` | canvas_item.cpp 140行目 |
| 14 | drawing = trueで描画中フラグセット | `drawing = true;` | canvas_item.cpp 145行目 |
| 15 | NOTIFICATION_DRAWを通知 | `notification(NOTIFICATION_DRAW);` | canvas_item.cpp 148行目 |
| 16 | "draw"シグナルを発行 | `emit_signal(SceneStringName(draw));` | canvas_item.cpp 149行目 |
| 17 | GDVIRTUAL_CALL(_draw)で仮想関数呼び出し | `GDVIRTUAL_CALL(_draw);` | canvas_item.cpp 150行目 |
| 18 | drawing = falseで描画完了 | `drawing = false;` | canvas_item.cpp 153行目 |

### 2.5 get_global_transform()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 19 | _is_global_invalid()でキャッシュ有効性確認 | `if (_is_global_invalid())` | canvas_item.cpp 179行目 |
| 20 | 親のget_global_transform()と自身のget_transform()を乗算 | `new_global = pi->get_global_transform() * get_transform()` | canvas_item.cpp 184行目 |
| 21 | global_transformにキャッシュ | `global_transform = new_global;` | canvas_item.cpp 189行目 |
| 22 | _set_global_invalid(false)でキャッシュ有効化 | `_set_global_invalid(false);` | canvas_item.cpp 190行目 |

### 2.6 Sprite2D::_notification()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 23 | NOTIFICATION_DRAWで描画処理 | `case NOTIFICATION_DRAW:` | sprite_2d.cpp 158行目 |
| 24 | texture.is_null()で早期リターン | `if (texture.is_null()) return;` | sprite_2d.cpp 159-161行目 |
| 25 | get_canvas_item()でRID取得 | `RID ci = get_canvas_item();` | sprite_2d.cpp 163行目 |
| 26 | _get_rects()でソース/デスト矩形計算 | `_get_rects(src_rect, dst_rect, filter_clip_enabled);` | sprite_2d.cpp 167行目 |
| 27 | texture->draw_rect_region()で描画 | `texture->draw_rect_region(ci, dst_rect, src_rect, ...)` | sprite_2d.cpp 169行目 |

### 2.7 Sprite2D::_get_rects()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 28 | region_enabledでリージョン領域使用 | `if (region_enabled) base_rect = region_rect;` | sprite_2d.cpp 98-104行目 |
| 29 | hframes/vframesでフレームサイズ計算 | `Size2 frame_size = base_rect.size / Size2(hframes, vframes);` | sprite_2d.cpp 106行目 |
| 30 | frameからフレームオフセット計算 | `Point2 frame_offset = Point2(frame % hframes, frame / hframes);` | sprite_2d.cpp 107行目 |
| 31 | centeredでオフセット調整 | `if (centered) dest_offset -= frame_size / 2;` | sprite_2d.cpp 114-116行目 |
| 32 | hflip/vflipでサイズ反転 | `if (hflip) r_dst_rect.size.x = -r_dst_rect.size.x;` | sprite_2d.cpp 124-128行目 |

### 2.8 可視性制御に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 33 | _propagate_visibility_changed()で可視性伝播 | メソッド実装 | canvas_item.cpp 67-74行目 |
| 34 | canvas_item_set_visible()でRenderingServer更新 | `RenderingServer::get_singleton()->canvas_item_set_visible(...)` | canvas_item.cpp 93行目 |
| 35 | 子ノードへ再帰的に伝播 | forループで子ノードに_propagate_visibility_changed() | canvas_item.cpp 103-109行目 |
| 36 | 非表示時に"hidden"シグナル発行 | `emit_signal(SceneStringName(hidden));` | canvas_item.cpp 99行目 |

### 2.9 キャンバス管理に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 37 | _enter_canvas()でキャンバス参入 | メソッド実装 | canvas_item.cpp 234-285行目 |
| 38 | 親がCanvasItemならcanvas_layerを継承 | `canvas_layer = parent_item->canvas_layer;` | canvas_item.cpp 243行目 |
| 39 | canvas_item_set_parent()でRenderingServer登録 | `RenderingServer::get_singleton()->canvas_item_set_parent(...)` | canvas_item.cpp 244行目 |
| 40 | CanvasLayerを探索して設定 | whileループでCanvasLayer探索 | canvas_item.cpp 251-260行目 |

### 2.10 通知定数に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 41 | NOTIFICATION_DRAW = 30 | enum定義 | canvas_item.h 211行目 |
| 42 | NOTIFICATION_VISIBILITY_CHANGED = 31 | enum定義 | canvas_item.h 212行目 |
| 43 | NOTIFICATION_ENTER_CANVAS = 32 | enum定義 | canvas_item.h 213行目 |
| 44 | NOTIFICATION_EXIT_CANVAS = 33 | enum定義 | canvas_item.h 214行目 |

### 2.11 ERR_DRAW_GUARDに関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 45 | ERR_DRAW_GUARDマクロでdrawingフラグチェック | `#define ERR_DRAW_GUARD ERR_FAIL_COND_MSG(!drawing, ...)` | canvas_item.cpp 43-44行目 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | GDScriptでの使用例の構文 | GDScript実装はC++コードからは直接確認不可（ただし一般的な使用法として妥当） |

## 4. 信頼度評価

### 4.1 評価基準

- 全45主張中44主張にソースコード根拠あり
- 根拠なし1件はGDScript構文例（設計書として許容範囲）
- 全ての重要な技術的主張は行番号付きで検証済み

### 4.2 最終信頼度

**信頼度: 98%**

## 5. 検証に使用したソースファイル

| ファイル | 確認行数 | 検証項目数 |
|----------|----------|------------|
| scene/main/canvas_item.cpp | 1-600 | 22 |
| scene/main/canvas_item.h | 1-300 | 12 |
| scene/2d/sprite_2d.cpp | 1-559 | 9 |
| scene/2d/sprite_2d.h | 1-140 | 2 |

## 6. 特記事項

### 6.1 コード品質の観察

1. **遅延描画パターン**: queue_redraw()とpending_updateによる効率的な再描画管理
2. **キャッシュ戦略**: global_transformの遅延計算とinvalidフラグによる更新最適化
3. **スレッド安全性**: ERR_THREAD_GUARD/ERR_READ_THREAD_GUARD_Vマクロによる保護

### 6.2 設計パターンの確認

- 複合パターン（Composite）: CanvasItemの親子関係
- オブザーバーパターン: "draw"/"visibility_changed"シグナル
- テンプレートメソッドパターン: _notification()と_draw()仮想関数
