---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-CSG（構成立体幾何）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/csg/csg_shape.cpp` - ManifoldProperty列挙型（238-247行目）
- E-02: `modules/csg/csg_shape.cpp` - _unpack_manifold関数（249-299行目）
- E-03: `modules/csg/csg_shape.cpp` - _pack_manifold関数（367-432行目）
- E-04: `modules/csg/csg_shape.cpp` - ManifoldOperation構造体（434-451行目）
- E-05: `modules/csg/csg_shape.cpp` - _get_brush関数（453-512行目）
- E-06: `modules/csg/csg_shape.cpp` - update_shape関数（568-734行目）
- E-07: `modules/csg/csg_shape.cpp` - MikkTSpace関数群（514-566行目）
- E-08: `modules/csg/csg_shape.cpp` - set_use_collision関数（85-118行目）
- E-09: `modules/csg/csg_shape.cpp` - _update_collision_faces関数（767-775行目）
- E-10: `modules/csg/csg_shape.cpp` - CSGSphere3D::_build_brush（1324-1453行目）
- E-11: `modules/csg/csg_shape.cpp` - CSGBox3D::_build_brush（1536-1599行目）
- E-12: `modules/csg/csg_shape.cpp` - is_root_shape関数（200-202行目）
- E-13: `modules/csg/csg_shape.cpp` - コリジョンレイヤー設定（142-176行目）
- E-14: `modules/csg/csg_shape.cpp` - _bind_methods（997-1057行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Manifoldライブラリを使用 | E-01、E-02、E-03、E-05 | ○ |
| C-02 | 3種類のブーリアン演算（Union/Intersection/Subtraction） | E-04（437-445行目） | ○ |
| C-03 | OPERATION_UNIONはmanifold::OpType::Addに変換 | E-04（444行目） | ○ |
| C-04 | OPERATION_SUBTRACTIONはmanifold::OpType::Subtractに変換 | E-04（440行目） | ○ |
| C-05 | OPERATION_INTERSECTIONはmanifold::OpType::Intersectに変換 | E-04（442行目） | ○ |
| C-06 | BatchBooleanで同一演算をバッチ処理 | E-05（483行目、491行目） | ○ |
| C-07 | ルート形状のみがメッシュを描画 | E-12（200-202行目）、E-06（569-571行目） | ○ |
| C-08 | MikkTSpaceでタンジェント計算 | E-07（514-566行目）、E-06（693-707行目） | ○ |
| C-09 | ConcavePolygonShape3Dでコリジョン生成 | E-08（97行目）、E-09（769行目） | ○ |
| C-10 | コリジョン設定はルート形状でのみ有効 | E-08（92行目） | ○ |
| C-11 | dirty flagで変更追跡 | E-05（454-456行目） | ○ |
| C-12 | call_deferredで遅延更新 | E-08行目（222行目）、E-08（231行目） | ○ |
| C-13 | コリジョンレイヤー1-32の範囲チェック | E-13（143-144行目） | ○ |
| C-14 | 球の面数計算式 | E-10（1329行目） | ○ |
| C-15 | 球のradial_segmentsは4以上 | E-10（1489行目） | ○ |
| C-16 | 球のringsは1以上 | E-10（1499行目） | ○ |
| C-17 | radiusは0より大きい必要がある | E-10（1478行目） | ○ |
| C-18 | ボックスは12面 | E-11（1541行目） | ○ |
| C-19 | ArrayMeshに変換して描画 | E-06（687行目、724-726行目） | ○ |
| C-20 | bake_static_mesh機能 | E-06（736-742行目） | ○ |
| C-21 | bake_collision_shape機能 | E-09（777-787行目） | ○ |
| C-22 | 非マニフォールドメッシュの警告 | E-14（977-988行目） | ○ |
| C-23 | parent_shapeで親子関係管理 | E-12（201行目）、E-05（227-228行目） | ○ |
| C-24 | 関連ファイル一覧の正確性 | E-01〜E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ブーリアン演算タイプの変換が正確か
- [ ] BatchBoolean処理の条件が正確か
- [ ] MikkTSpace関数の呼び出しが正確か
- [ ] コリジョン生成条件が正確か
