---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-メッシュライブラリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：RBMapの計算量に関する記述が概念的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/resources/3d/mesh_library.h` - クラス定義・Item構造体
- E-02: `scene/resources/3d/mesh_library.cpp` - メソッド実装（create_item等）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.61の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.48との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshLibraryはResourceクラスを継承 | E-01 (44行目 GDCLASS) | ○ |
| C-02 | RBMapでアイテムを管理 | E-01 (68行目) | ○ |
| C-03 | Item構造体にmesh,transform,shadow等を保持 | E-01 (54-66行目) | ○ |
| C-04 | ShapeData構造体でShape3DとTransformをペア保持 | E-01 (49-52行目) | ○ |
| C-05 | create_itemでIDの負数チェック | E-02 (159行目 ERR_FAIL_COND) | ○ |
| C-06 | create_itemで重複IDチェック | E-02 (160行目 ERR_FAIL_COND) | ○ |
| C-07 | set_item_meshでメッシュ設定後emit_changed | E-02 (172-176行目) | ○ |
| C-08 | set_item_shapesで物理形状設定 | E-02 (191-196行目) | ○ |
| C-09 | set_item_navigation_meshでナビメッシュ設定 | E-02 (199-203行目) | ○ |
| C-10 | remove_itemでitem_mapからエントリ削除 | E-02 (274-279行目) | ○ |
| C-11 | _setメソッドで"item/{id}/{prop}"形式解析 | E-02 (37-102行目) | ○ |
| C-12 | mesh_cast_shadowは0-3の値を取る | E-02 (53-68行目 switch文) | ○ |
| C-13 | 拡張子は.meshlib | E-01 (45行目 RES_BASE_EXTENSION) | ○ |
| C-14 | NavigationMesh連携機能あり | E-01 (63-65行目), E-02 (199-215行目) | ○ |
| C-15 | navigation_layersはuint32_t | E-01 (65行目) | ○ |
| C-16 | 画面No.48はメッシュライブラリエディタ | E-04 (109行目) | ○ |
| C-17 | GridMapとの連携が主要用途 | E-03 (61行目 説明) | ○ |
| C-18 | アイテム追加・取得はO(log n) | **根拠なし**（一般的なRBMap特性から推測） | △ |

## 4) 不足情報（Unknown / Missing）
- RBMapの計算量に関する公式ドキュメントまたはコード内コメント
  - 候補：Godotのcore/templates/rb_map.hの実装確認 / C++標準ライブラリの赤黒木仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の説明は全てコードで検証済み
- 0: 低リスク - API仕様はbind_methodsから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Item構造体の各フィールドが正しく文書化されているか確認
- [ ] シャドウキャスト設定値（0-3）の意味が正しいか確認
- [ ] GridMapとの連携部分は別途gridmap.cppで確認
