---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：62-glTFインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：処理時間は推測値
  2. **MikkTSpaceアルゴリズム使用**：コード内での明示的参照を確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/gltf/gltf_document.cpp` - メインドキュメントクラス実装
- E-02: `modules/gltf/gltf_document.h` - クラス定義
- E-03: `modules/gltf/gltf_state.cpp` - 状態管理
- E-04: `modules/gltf/editor/editor_scene_importer_gltf.cpp` - エディタ統合
- E-05: `modules/gltf/editor/editor_scene_importer_blend.cpp` - Blender連携
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.62の定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | glTF 2.0形式をサポート | E-01 (ファイル全体) | ○ |
| C-02 | .gltf/.glb両形式対応 | E-04 (get_extensions) | ○ |
| C-03 | _serializeでエクスポート処理 | E-01 (102-200行目) | ○ |
| C-04 | メッシュ変換処理あり | E-01 (_serialize_meshes) | ○ |
| C-05 | マテリアル変換処理あり | E-01 (_serialize_materials) | ○ |
| C-06 | アニメーション変換処理あり | E-01 (_serialize_animations) | ○ |
| C-07 | スケルトン/スキン処理あり | E-01 (_serialize_skins) | ○ |
| C-08 | テクスチャ処理あり | E-01 (_serialize_textures, _serialize_images) | ○ |
| C-09 | GLTFDocumentExtensionで拡張可能 | E-01 (103-107行目 for ext loop) | ○ |
| C-10 | Blender連携機能あり | E-05 (editor_scene_importer_blend.cpp) | ○ |
| C-11 | PBRマテリアルをStandardMaterial3Dに変換 | E-01 (_serialize_materials) | ○ |
| C-12 | ノード階層構築機能あり | E-01 (_serialize_nodes) | ○ |
| C-13 | インポートフラグでタンジェント生成制御 | E-01 (76-77行目 #define) | ○ |
| C-14 | カメラ変換処理あり | E-01 (_serialize_cameras) | ○ |
| C-15 | ライト拡張サポート | E-01 (_serialize_lights) | ○ |
| C-16 | バッファ/アクセサ処理 | E-01 (_encode_accessors, _encode_buffer_views) | ○ |
| C-17 | 画面No.13はインポートドック | E-07 (41行目) | ○ |
| C-18 | SkinToolでスキン処理 | E-01 (37行目 #include "skin_tool.h") | ○ |
| C-19 | 小規模モデルは1秒未満で処理 | **根拠なし**（推測値） | △ |
| C-20 | MikkTSpaceでタンジェント生成 | **根拠なし**（コード内確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス測定データ
  - 候補：ベンチマークテスト結果 / プロファイリングデータ
- タンジェント生成アルゴリズムの明示的な参照
  - 候補：SurfaceToolの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な変換処理はコードで確認済み
- 1: 中リスク - パフォーマンス要件は実測が必要
- 0: 低リスク - 拡張機能システムはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] glTF 2.0仕様との互換性を確認
- [ ] Blender連携の動作確認
- [ ] 大規模モデルインポート時のパフォーマンス確認
- [ ] カスタム拡張機能の実装方法を確認
