---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：63-FBXインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ufbxライブラリのライセンス情報**：正確なライセンス確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/fbx/fbx_document.cpp` - メインドキュメントクラス実装
- E-02: `modules/fbx/fbx_document.h` - クラス定義
- E-03: `modules/fbx/editor/editor_scene_importer_ufbx.cpp` - エディタ統合
- E-04: `modules/fbx/editor/editor_scene_importer_fbx2gltf.cpp` - fbx2gltf連携
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.63の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ufbxライブラリを使用 | E-01 (64行目 #include <ufbx.h>) | ○ |
| C-02 | _as_vec2関数でVector2変換 | E-01 (77-79行目) | ○ |
| C-03 | _as_color関数でColor変換 | E-01 (81-83行目) | ○ |
| C-04 | _as_quaternion関数でQuaternion変換 | E-01 (85-87行目) | ○ |
| C-05 | _as_transform関数でTransform3D変換 | E-01 (89-94行目) | ○ |
| C-06 | カスタムファイルアクセスコールバック | E-01 (66-75行目) | ○ |
| C-07 | _material_color関数でマテリアルカラー取得 | E-01 (100-127行目) | ○ |
| C-08 | _decode_vertex_attrib_vec2でUVデコード | E-01 (154-163行目) | ○ |
| C-09 | _decode_vertex_attrib_vec3で法線/頂点デコード | E-01 (165-174行目) | ○ |
| C-10 | _decode_vertex_attrib_vec3_as_tangentでタンジェントデコード | E-01 (176-189行目) | ○ |
| C-11 | _decode_vertex_attrib_colorで頂点カラーデコード | E-01 (191-199行目) | ○ |
| C-12 | glTFモジュールの構造体を活用 | E-01 (49-53行目 includes) | ○ |
| C-13 | SkinToolを使用 | E-01 (51行目 #include "modules/gltf/skin_tool.h") | ○ |
| C-14 | fbx2gltfによる変換オプションあり | E-04 (ファイル存在) | ○ |
| C-15 | FBX_IMPORT_USE_NAMED_SKIN_BINDSフラグ | E-01 (60行目 #define) | ○ |
| C-16 | 画面No.13はインポートドック | E-06 (42行目) | ○ |
| C-17 | _get_file_textureでファイルテクスチャ取得 | E-01 (129-139行目) | ○ |
| C-18 | ufbxはMIT/Public Domainライセンス | **根拠なし**（ufbxリポジトリ確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- ufbxライブラリの正確なライセンス情報
  - 候補：ufbxのGitHubリポジトリのLICENSEファイル確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な変換処理はコードで確認済み
- 0: 低リスク - glTFモジュール連携はコードで確認済み
- 1: 中リスク - 外部ライブラリのライセンス確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ufbxライブラリのライセンスを確認
- [ ] 座標系変換が正しく行われているか確認
- [ ] マテリアル変換の精度を確認
- [ ] 大規模FBXファイルのインポートパフォーマンスを確認
