---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-OBJインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張がソースコードで確認済み）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/import/3d/resource_importer_obj.cpp` - メインインポーター実装
- E-02: `editor/import/3d/resource_importer_obj.h` - クラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.64の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インポーター名は"wavefront_obj" | E-01 (609-611行目) | ○ |
| C-02 | .obj拡張子をサポート | E-01 (617-619行目 get_recognized_extensions) | ○ |
| C-03 | generate_tangentsオプション | E-01 (642行目) | ○ |
| C-04 | generate_lodsオプション | E-01 (643行目) | ○ |
| C-05 | generate_shadow_meshオプション | E-01 (644行目) | ○ |
| C-06 | generate_lightmap_uv2オプション | E-01 (645行目) | ○ |
| C-07 | scale_meshオプション | E-01 (647行目) | ○ |
| C-08 | offset_meshオプション | E-01 (648行目) | ○ |
| C-09 | COFFヘッダーチェック | E-01 (227-235行目) | ○ |
| C-10 | v コマンドで頂点解析 | E-01 (276-297行目) | ○ |
| C-11 | vt コマンドでUV解析 | E-01 (298-305行目) | ○ |
| C-12 | vn コマンドで法線解析 | E-01 (306-314行目) | ○ |
| C-13 | f コマンドでフェイス構築 | E-01 (315-386行目) | ○ |
| C-14 | UV座標のY反転 (1.0 - v) | E-01 (304行目) | ○ |
| C-15 | 負のインデックス対応 | E-01 (342-344行目, 352-354行目) | ○ |
| C-16 | mtllib でMTL読み込み | E-01 (510-523行目) | ○ |
| C-17 | usemtl でマテリアル切替 | E-01 (502-504行目) | ○ |
| C-18 | 行継続（バックスラッシュ） | E-01 (267-274行目) | ○ |
| C-19 | スムージンググループ (s) | E-01 (387-400行目) | ○ |
| C-20 | 頂点カラー対応 | E-01 (286-297行目) | ○ |
| C-21 | Kd からディフューズカラー | E-01 (61-70行目) | ○ |
| C-22 | Ks からメタリック近似 | E-01 (71-80行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードで検証済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要処理がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各OBJコマンドの解析が正しいか確認
- [ ] MTLファイルのマテリアルプロパティ変換精度を確認
- [ ] 大規模OBJファイルのインポートパフォーマンスを確認
