---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：67-OpenXR対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **対応VRヘッドセットリスト**：具体的なデバイスリストはOpenXRランタイム依存

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/openxr/openxr_interface.cpp` - メインインターフェース
- E-02: `modules/openxr/openxr_api.cpp` - OpenXR API実装
- E-03: `modules/openxr/action_map/openxr_action_map.cpp` - アクションマップ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.67の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インターフェース名は"OpenXR" | E-01 (196-198行目) | ○ |
| C-02 | display_refresh_rateプロパティ | E-01 (62-64行目) | ○ |
| C-03 | render_target_size_multiplierプロパティ | E-01 (67-69行目) | ○ |
| C-04 | foveation_levelプロパティ | E-01 (74-76行目) | ○ |
| C-05 | foveation_dynamicプロパティ | E-01 (78-80行目) | ○ |
| C-06 | vrs_min_radiusプロパティ | E-01 (110-111行目, 120行目) | ○ |
| C-07 | vrs_strengthプロパティ | E-01 (112-113行目, 121行目) | ○ |
| C-08 | session_begunシグナル | E-01 (45行目) | ○ |
| C-09 | session_stoppingシグナル | E-01 (46行目) | ○ |
| C-10 | pose_recenteredシグナル | E-01 (52行目) | ○ |
| C-11 | SESSION_STATE_* enum | E-01 (123-131行目) | ○ |
| C-12 | HAND_*定数 | E-01 (133-135行目) | ○ |
| C-13 | HAND_JOINT_*定数 | E-01 (146-172行目) | ○ |
| C-14 | ハンドトラッキングサポート | E-01 (91-107行目) | ○ |
| C-15 | アクションセット管理 | E-01 (83-86行目) | ○ |
| C-16 | パフォーマンス設定 | E-01 (116-117行目) | ○ |
| C-17 | 拡張機能システム | E-01 (36-40行目 includes) | ○ |
| C-18 | 対応VRデバイス一覧 | **根拠なし**（OpenXRランタイム依存） | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な対応VR/ARデバイスリスト
  - 候補：OpenXRランタイムドキュメント参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義はコードで確認済み
- 1: 中リスク - デバイス互換性はランタイム依存

## 6) レビュアーチェックリスト（最小）
- [ ] 主要VRヘッドセットでの動作確認
- [ ] ハンドトラッキング機能の確認
- [ ] パフォーマンス設定の効果確認
