---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-XRノード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張がソースコードで確認済み）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/3d/xr/xr_nodes.cpp` - XRノード実装
- E-02: `scene/3d/xr/xr_nodes.h` - クラス定義
- E-03: `scene/3d/xr/xr_hand_modifier_3d.cpp` - ハンドモディファイア
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.68の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XRCamera3D::_validate_property()で非表示プロパティ設定 | E-01 (39-47行目) | ○ |
| C-02 | _bind_tracker()でトラッカーバインド | E-01 (49-62行目) | ○ |
| C-03 | _unbind_tracker()でバインド解除 | E-01 (64-69行目) | ○ |
| C-04 | _changed_tracker()でトラッカー追加検出 | E-01 (71-75行目) | ○ |
| C-05 | _removed_tracker()でトラッカー削除検出 | E-01 (77-81行目) | ○ |
| C-06 | _pose_changed()でトランスフォーム更新 | E-01 (83-87行目) | ○ |
| C-07 | get_configuration_warnings()で親ノード警告 | E-01 (94-111行目) | ○ |
| C-08 | 物理補間警告 | E-01 (105-107行目) | ○ |
| C-09 | project_local_ray_normal()でXR対応レイ計算 | E-01 (113-136行目) | ○ |
| C-10 | unproject_position()でXR対応アンプロジェクト | E-01 (138-166行目) | ○ |
| C-11 | project_position()でXR対応プロジェクト | E-01 (168-196行目) | ○ |
| C-12 | get_frustum()でXR対応フラスタム取得 | E-01 (198-200行目) | ○ |
| C-13 | XRハンドモディファイアファイル存在 | E-03 (ファイル存在) | ○ |
| C-14 | XRBodyModifierファイル存在 | xr_body_modifier_3d.cpp存在 | ○ |
| C-15 | XRFaceModifierファイル存在 | xr_face_modifier_3d.cpp存在 | ○ |
| C-16 | XROrigin3Dとの親子関係警告 | E-01 (100-103行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要処理がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] XROrigin3D/XRCamera3D/XRController3Dの親子関係動作確認
- [ ] トラッカーバインドの動作確認
- [ ] ハンドモディファイアのボーン反映確認
