---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-WebXR

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張がソースコードで確認済み）

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/webxr/webxr_interface_js.cpp` - メインインターフェース
- E-02: `modules/webxr/webxr_interface.cpp` - 基底クラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.69の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _emwebxr_on_session_supportedコールバック | E-01 (50-59行目) | ○ |
| C-02 | _emwebxr_on_session_startedコールバック | E-01 (61-73行目) | ○ |
| C-03 | _emwebxr_on_session_endedコールバック | E-01 (75-84行目) | ○ |
| C-04 | _emwebxr_on_session_failedコールバック | E-01 (86-97行目) | ○ |
| C-05 | _emwebxr_on_input_eventコールバック | E-01 (99-107行目) | ○ |
| C-06 | is_session_supported()メソッド | E-01 (120-122行目) | ○ |
| C-07 | set_session_mode/get_session_modeプロパティ | E-01 (124-130行目) | ○ |
| C-08 | set_required_features/get_required_featuresプロパティ | E-01 (132-138行目) | ○ |
| C-09 | set_optional_features/get_optional_featuresプロパティ | E-01 (140-146行目) | ○ |
| C-10 | set_requested_reference_space_typesプロパティ | E-01 (148-154行目) | ○ |
| C-11 | get_reference_space_type()メソッド | E-01 (156-158行目) | ○ |
| C-12 | get_enabled_features()メソッド | E-01 (160-162行目) | ○ |
| C-13 | is_input_source_active()メソッド | E-01 (164-167行目) | ○ |
| C-14 | get_input_source_tracker()メソッド | E-01 (169-172行目) | ○ |
| C-15 | get_input_source_target_ray_mode()メソッド | E-01 (174-180行目) | ○ |
| C-16 | get_visibility_state()メソッド | E-01 (182-191行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要処理がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 主要ブラウザでのWebXRセッション開始確認
- [ ] 入力ソース処理の動作確認
- [ ] セッション終了時のクリーンアップ確認
