---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：70-TextServer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `servers/text/text_server.h` - TextServer/TextServerManagerクラス定義
- E-02: `servers/text/text_server.cpp` - 基底クラス実装
- E-03: `modules/text_server_adv/text_server_adv.cpp` - Advanced実装
- E-04: `modules/text_server_fb/text_server_fb.cpp` - Fallback実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.70の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextServerクラスはRefCounted継承 | E-01 (47-48行目) | ○ |
| C-02 | FontAntialiasing enum (NONE/GRAY/LCD) | E-01 (51-55行目) | ○ |
| C-03 | Direction enum (AUTO/LTR/RTL/INHERITED) | E-01 (66-71行目) | ○ |
| C-04 | Orientation enum (HORIZONTAL/VERTICAL) | E-01 (73-76行目) | ○ |
| C-05 | Feature enum (SIMPLE_LAYOUT〜UNICODE_SECURITY) | E-01 (176-192行目) | ○ |
| C-06 | Glyph構造体定義 | E-01 (625-648行目) | ○ |
| C-07 | CaretInfo構造体定義 | E-01 (650-655行目) | ○ |
| C-08 | TextServerManagerシングルトン | E-01 (659-690行目) | ○ |
| C-09 | add_interface()メソッド | E-02 (60-73行目) | ○ |
| C-10 | remove_interface()メソッド | E-02 (75-91行目) | ○ |
| C-11 | set_primary_interface()メソッド | E-02 (130-142行目) | ○ |
| C-12 | TextServerManager::_bind_methods() | E-02 (45-58行目) | ○ |
| C-13 | TextServer::_bind_methods() | E-02 (198-500行目) | ○ |
| C-14 | TextServerAdvanced::_has_feature() | E-03 (355-380行目) | ○ |
| C-15 | TextServerAdvanced::_get_name() | E-03 (382-388行目) | ○ |
| C-16 | TextServerFallback::_has_feature() | E-04 (89-104行目) | ○ |
| C-17 | TextServerFallback::_get_name() | E-04 (106-112行目) | ○ |
| C-18 | HarfBuzz統合（bmp_font_funcs） | E-03 (94-265行目) | ○ |
| C-19 | ICU統合（is_ain, is_alef等） | E-03 (271-298行目) | ○ |
| C-20 | シェーピングキャッシュ・オンデマンド生成 | **根拠不足**（実装詳細は確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値・ベンチマーク結果
- キャッシュ戦略の詳細実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義・クラス構造はコードで確認済み
- 1: 中リスク - パフォーマンス要件は実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 多言語テキスト（日本語・アラビア語・中国語）の表示確認
- [ ] RTLテキストの正しい表示確認
- [ ] MSDFフォントのスケーリング確認
- [ ] フォールバック実装での基本動作確認
