---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-フォント管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：キャッシュサイズ等の具体値は未確認
  2. **外部ライブラリ連携**：HarfBuzz/FreeType連携の詳細は別モジュール参照必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/resources/font.cpp` (1-500行目)
- E-02: `scene/resources/font.h`
- E-03: `scene/resources/text_line.cpp`
- E-04: `scene/resources/text_paragraph.cpp`
- E-05: `editor/scene/gui/font_config_plugin.cpp`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 71行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TrueType/OpenTypeフォント対応 | E-01 (font.cpp) | ○ |
| C-02 | フォントメトリクス取得（height, ascent, descent） | E-01 (210-264行目) | ○ |
| C-03 | draw_string/draw_multiline_string実装 | E-01 (349-410行目) | ○ |
| C-04 | フォントフォールバック機構 | E-01 (104-150行目, _update_rids_fb, _is_cyclic) | ○ |
| C-05 | TextServerとの連携 | E-01 (217, 228等 TS->font_get_*呼び出し) | ○ |
| C-06 | キャッシュ機構 | E-01 (305-313行目 cache.has/cache.insert) | ○ |
| C-07 | 循環参照防止ロジック | E-01 (135-150行目 _is_cyclic) | ○ |
| C-08 | 最大フォールバック深度64 | E-01 (MAX_FALLBACK_DEPTH定数) | ○ |
| C-09 | get_string_size実装 | E-01 (300-323行目) | ○ |
| C-10 | アウトライン描画対応 | E-01 (412-442行目 draw_string_outline) | ○ |
| C-11 | 個別文字描画対応 | E-01 (476-500行目 get_char_size, draw_char) | ○ |
| C-12 | set_fallbacks実装 | E-01 (176-195行目) | ○ |
| C-13 | フォント名取得 | E-01 (266-268行目 get_font_name) | ○ |
| C-14 | フォントスタイル取得 | E-01 (278-280行目 get_font_style) | ○ |
| C-15 | OpenTypeフィーチャー対応 | E-01 (290-292行目 get_opentype_features) | ○ |
| C-16 | キャッシュ容量設定 | E-01 (295-298行目 set_cache_capacity) | ○ |
| C-17 | HarfBuzz連携 | **根拠なし** (別モジュール参照必要) | △ |
| C-18 | 可変フォント対応 | **根拠なし** (FontVariationクラス要確認) | △ |

## 4) 不足情報（Unknown / Missing）
- HarfBuzz/FreeTypeとの連携詳細（modules/text_server_*配下）
  - 候補：`modules/text_server_adv/text_server_adv.cpp` / `modules/text_server_fb/`
- FontVariationクラスの実装詳細
  - 候補：`scene/resources/font.cpp`の後半部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の実装は確認済み
- 1: 中リスク - 外部ライブラリ連携の詳細は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] フォントフォールバックの最大深度64が適切か確認
- [ ] キャッシュサイズのデフォルト値が十分か確認
- [ ] HarfBuzz/FreeType連携の詳細が必要な場合は別途調査
