---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：72-国際化（i18n）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **XLIFFサポート**：実装ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/string/translation_server.cpp` (1-786行目)
- E-02: `core/string/translation_server.h`
- E-03: `core/io/translation_loader_po.cpp`
- E-04: `core/string/translation.cpp`
- E-05: `core/string/translation_domain.cpp`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 72行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ロケール情報初期化（init_locale_info） | E-01 (41-153行目) | ○ |
| C-02 | 翻訳リソース読み込み | E-03 (translation_loader_po.cpp) | ○ |
| C-03 | translate実装 | E-01 (556-558行目) | ○ |
| C-04 | translate_plural実装 | E-01 (560-562行目) | ○ |
| C-05 | standardize_locale実装 | E-01 (315-317行目) | ○ |
| C-06 | compare_locales実装 | E-01 (319-375行目) | ○ |
| C-07 | 複数形ルール処理 | E-01 (405-423行目 get_plural_rules) | ○ |
| C-08 | 言語名取得 | E-01 (435-441行目 get_language_name) | ○ |
| C-09 | 国名取得 | E-01 (471-477行目 get_country_name) | ○ |
| C-10 | ロケール設定 | E-01 (479-493行目 set_locale) | ○ |
| C-11 | フォールバックロケール | E-01 (499-505行目 set_fallback_locale) | ○ |
| C-12 | 擬似ローカライズ | E-01 (644-677行目 pseudolocalize) | ○ |
| C-13 | 翻訳ドメイン管理 | E-01 (564-590行目 get_or_add_domain, remove_domain) | ○ |
| C-14 | 数値フォーマット | E-01 (255-276行目 format_number) | ○ |
| C-15 | パーセント記号取得 | E-01 (305-313行目 get_percent_sign) | ○ |
| C-16 | ロケール名取得 | E-01 (377-403行目 get_locale_name) | ○ |
| C-17 | プロジェクト翻訳読み込み | E-01 (756-771行目 load_project_translations) | ○ |
| C-18 | ロケール比較キャッシュ | E-01 (325-329行目 locale_compare_cache) | ○ |
| C-19 | TranslationServerシングルトン | E-01 (773-774行目 singleton) | ○ |
| C-20 | XLIFFサポート | **根拠なし** (別ファイル要確認) | △ |

## 4) 不足情報（Unknown / Missing）
- XLIFFローダーの実装詳細
  - 候補：`editor/import/resource_importer_*` 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能はすべてソースコードで確認済み
- 1: 中リスク - XLIFFサポートの有無は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] compare_localesのスコア計算ロジックが意図通りか確認
- [ ] 複数形ルールの言語カバレッジが十分か確認
- [ ] 擬似ローカライズ設定がテスト用途に適切か確認
