---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-タイマー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/timer.cpp` (1-250行目)
- E-02: `scene/main/timer.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 73行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | start()実装 | E-01 (118-126行目) | ○ |
| C-02 | stop()実装 | E-01 (128-132行目) | ○ |
| C-03 | set_paused()実装 | E-01 (134-141行目) | ○ |
| C-04 | set_wait_time()バリデーション | E-01 (92-96行目) | ○ |
| C-05 | one_shotプロパティ | E-01 (102-108行目) | ○ |
| C-06 | autostartプロパティ | E-01 (110-116行目) | ○ |
| C-07 | timeoutシグナル発火 | E-01 (66, 86行目) | ○ |
| C-08 | NOTIFICATION_READY処理 | E-01 (37-47行目) | ○ |
| C-09 | NOTIFICATION_INTERNAL_PROCESS処理 | E-01 (49-68行目) | ○ |
| C-10 | NOTIFICATION_INTERNAL_PHYSICS_PROCESS処理 | E-01 (70-88行目) | ○ |
| C-11 | ignore_time_scaleプロパティ | E-01 (147-153行目) | ○ |
| C-12 | タイムスケール無視時の計算 | E-01 (53-54, 74-75行目) | ○ |
| C-13 | 低待機時間警告 | E-01 (201-208行目 get_configuration_warnings) | ○ |
| C-14 | シーンツリー外start()エラー | E-01 (119行目 ERR_FAIL_COND_MSG) | ○ |
| C-15 | _bind_methods実装 | E-01 (211-249行目) | ○ |
| C-16 | エディタ内自動開始スキップ | E-01 (39-42行目 is_part_of_edited_scene) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（Timer機能は単一ファイルで完結しており、すべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな実装で全機能確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 0.05秒未満の警告閾値が適切か確認
- [ ] リピート時のtime_left += wait_timeが意図通りか確認（誤差累積の可能性）
