---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-正規表現

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/regex/regex.cpp` (1-432行目)
- E-02: `modules/regex/regex.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 74行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | compile()実装 | E-01 (179-205行目) | ○ |
| C-02 | search()実装 | E-01 (207-271行目) | ○ |
| C-03 | search_all()実装 | E-01 (273-290行目) | ○ |
| C-04 | sub()実装 | E-01 (335-360行目) | ○ |
| C-05 | clear()実装 | E-01 (172-177行目) | ○ |
| C-06 | is_valid()実装 | E-01 (362-364行目) | ○ |
| C-07 | get_pattern()実装 | E-01 (366-368行目) | ○ |
| C-08 | get_group_count()実装 | E-01 (370-378行目) | ○ |
| C-09 | get_names()実装 | E-01 (380-401行目) | ○ |
| C-10 | PCRE2_DUPNAMES設定 | E-01 (185行目) | ○ |
| C-11 | メモリ再割り当て処理 | E-01 (319-323行目 PCRE2_ERROR_NOMEMORY) | ○ |
| C-12 | Godotメモリアロケータ使用 | E-01 (40-48行目 _regex_malloc/_regex_free) | ○ |
| C-13 | RegExMatchクラス | E-01 (50-159行目) | ○ |
| C-14 | get_subject()実装 | E-01 (67-69行目) | ○ |
| C-15 | get_strings()実装 | E-01 (88-107行目) | ○ |
| C-16 | get_start()/get_end()実装 | E-01 (127-145行目) | ○ |
| C-17 | 名前付きグループサポート | E-01 (253-268行目) | ○ |
| C-18 | UNKNOWN_UNSETフラグ再試行 | E-01 (353-356行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（RegEx機能は単一ファイルで完結しており、すべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PCRE2ライブラリのラッパーとしてシンプルな実装
- 1: 中リスク - ReDoS攻撃への対策はユーザー責任

## 6) レビュアーチェックリスト（最小）
- [ ] ユーザー入力をパターンとして使用する際の注意喚起が十分か確認
- [ ] PCRE2のバージョンとセキュリティ更新状況を確認
