---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-JSON処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/io/json.cpp` (1-1633行目)
- E-02: `core/io/json.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 75行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parse()実装 | E-01 (598-607行目) | ○ |
| C-02 | stringify()実装 | E-01 (613-618行目) | ○ |
| C-03 | _get_token()トークナイザー | E-01 (196-415行目) | ○ |
| C-04 | _parse_value()パーサー | E-01 (417-459行目) | ○ |
| C-05 | _parse_array()配列パース | E-01 (461-497行目) | ○ |
| C-06 | _parse_object()オブジェクトパース | E-01 (499-560行目) | ○ |
| C-07 | _stringify()再帰変換 | E-01 (57-194行目) | ○ |
| C-08 | トークン定義 | E-01 (38-49行目 tk_name) | ○ |
| C-09 | 循環参照検出 | E-01 (119-122, 153-156行目 p_markers) | ○ |
| C-10 | 深度制限チェック | E-01 (58-61, 418-421行目 MAX_RECURSION_DEPTH) | ○ |
| C-11 | NaN処理 | E-01 (86-88行目) | ○ |
| C-12 | Infinity処理 | E-01 (81-85行目 1e99999) | ○ |
| C-13 | UTF-16サロゲートペア処理 | E-01 (305-349行目) | ○ |
| C-14 | エスケープシーケンス処理 | E-01 (258-361行目) | ○ |
| C-15 | get_error_line/get_error_message | E-01 (636-637行目 _bind_methods) | ○ |
| C-16 | from_native/to_native | E-01 (639-640行目, 670-1019, 1058-1540行目) | ○ |
| C-17 | ResourceFormatLoaderJSON | E-01 (1551-1602行目) | ○ |
| C-18 | ResourceFormatSaverJSON | E-01 (1604-1632行目) | ○ |
| C-19 | sort_keysオプション | E-01 (164-166行目) | ○ |
| C-20 | full_precisionオプション | E-01 (98-109行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（JSON機能は単一ファイルで完結しており、すべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 手書きパーサーで標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] allow_objects=trueでの潜在的セキュリティリスクが十分に文書化されているか確認
- [ ] MAX_RECURSION_DEPTHの値が適切か確認
