---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：76-暗号化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **mbedTLS実装詳細**：別モジュールの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/crypto/crypto.cpp` (1-259行目)
- E-02: `core/crypto/crypto.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 76行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CryptoKey基底クラス | E-01 (35-49行目) | ○ |
| C-02 | X509Certificate基底クラス | E-01 (51-64行目) | ○ |
| C-03 | TLSOptions実装 | E-01 (68-105行目) | ○ |
| C-04 | HMACContext基底クラス | E-01 (109-121行目) | ○ |
| C-05 | Crypto基底クラス | E-01 (125-179行目) | ○ |
| C-06 | hmac_digest実装 | E-01 (140-148行目) | ○ |
| C-07 | constant_time_compare実装 | E-01 (152-167行目) | ○ |
| C-08 | ResourceFormatLoaderCrypto | E-01 (183-225行目) | ○ |
| C-09 | ResourceFormatSaverCrypto | E-01 (227-258行目) | ○ |
| C-10 | .crt/.key/.pub拡張子対応 | E-01 (185-203, 207-211行目) | ○ |
| C-11 | ファクトリパターン | E-01 (35-41, 51-57, 116-121, 127-132行目) | ○ |
| C-12 | mbedTLS無効時エラー | E-01 (120-121, 131-132行目) | ○ |
| C-13 | TLSOptions.client | E-01 (68-75行目) | ○ |
| C-14 | TLSOptions.client_unsafe | E-01 (77-83行目) | ○ |
| C-15 | TLSOptions.server | E-01 (85-92行目) | ○ |
| C-16 | generate_self_signed_certificateデフォルト期間 | E-01 (172行目) | ○ |
| C-17 | _bind_methods API定義 | E-01 (169-179行目) | ○ |
| C-18 | mbedTLS実装詳細 | **根拠なし** (modules/mbedtls要確認) | △ |

## 4) 不足情報（Unknown / Missing）
- mbedTLS実装の詳細
  - 候補：`modules/mbedtls/crypto_mbedtls.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基底クラスは確認済み
- 1: 中リスク - mbedTLS実装の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] mbedTLSモジュール無効時の動作が適切に処理されているか確認
- [ ] constant_time_compareのタイミング攻撃耐性が十分か確認
- [ ] TLSOptions.client_unsafeの使用に関する警告が十分か確認
