---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：79-LightmapGI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ライトマッパーRD実装詳細**：別モジュール確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/lightmap_gi.cpp` (1-500行目)
- E-02: `scene/3d/lightmap_gi.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 79行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LightmapGIData::add_user()実装 | E-01 (46-53行目) | ○ |
| C-02 | ユーザーデータ管理 | E-01 (55-100行目) | ○ |
| C-03 | set_lightmap_textures()実装 | E-01 (102-129行目) | ○ |
| C-04 | set_shadowmask_textures()実装 | E-01 (135-165行目) | ○ |
| C-05 | 球面調和関数対応 | E-01 (197-204行目) | ○ |
| C-06 | set_capture_data()実装 | E-01 (222-241行目) | ○ |
| C-07 | BSPツリー構築 | E-01 (482-500行目 _bsp_get_simplex_side) | ○ |
| C-08 | _find_meshes_and_lights()実装 | E-01 (384-480行目) | ○ |
| C-09 | GI_MODE_STATIC判定 | E-01 (386行目) | ○ |
| C-10 | UV2チェック | E-01 (395-396行目) | ○ |
| C-11 | Normalチェック | E-01 (399-400行目) | ○ |
| C-12 | 三角形判定 | E-01 (392-393行目 PRIMITIVE_TRIANGLES) | ○ |
| C-13 | シャドウマスクモード | E-01 (368-370行目) | ○ |
| C-14 | _bind_methods API定義 | E-01 (326-366行目) | ○ |
| C-15 | LightmapProbe収集 | E-01 (465-470行目) | ○ |
| C-16 | Light3D収集 | E-01 (456-463行目) | ○ |
| C-17 | RenderingServer連携 | E-01 (190, 194, 228-236行目) | ○ |
| C-18 | LightmapperRD実装 | **根拠なし** (modules/lightmapper_rd要確認) | △ |

## 4) 不足情報（Unknown / Missing）
- LightmapperRDの実装詳細
  - 候補：`modules/lightmapper_rd/lightmapper_rd.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能は確認済み
- 1: 中リスク - ベイク処理の詳細は別モジュール参照

## 6) レビュアーチェックリスト（最小）
- [ ] ベイクエラー時の適切なエラーメッセージ確認
- [ ] UV2なしメッシュへの警告が適切か確認
- [ ] テクスチャサイズ制限の妥当性確認
