---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-VoxelGI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/voxel_gi.cpp` (1-500行目)
- E-02: `scene/3d/voxel_gi.h`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 80行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VoxelGIData::_set_data()実装 | E-01 (39-69行目) | ○ |
| C-02 | VoxelGIData::_get_data()実装 | E-01 (71-90行目) | ○ |
| C-03 | VoxelGIData::allocate()実装 | E-01 (92-97行目) | ○ |
| C-04 | get_octree_cells()実装 | E-01 (107-109行目) | ○ |
| C-05 | get_data_cells()実装 | E-01 (111-113行目) | ○ |
| C-06 | get_distance_field()実装 | E-01 (115-117行目) | ○ |
| C-07 | set_dynamic_range()実装 | E-01 (127-130行目) | ○ |
| C-08 | set_energy()実装 | E-01 (145-148行目) | ○ |
| C-09 | set_bias()実装 | E-01 (154-157行目) | ○ |
| C-10 | set_propagation()実装 | E-01 (136-139行目) | ○ |
| C-11 | set_use_two_bounces()実装 | E-01 (181-184行目) | ○ |
| C-12 | set_interior()実装 | E-01 (172-175行目) | ○ |
| C-13 | VoxelGI::_find_meshes()実装 | E-01 (329-387行目) | ○ |
| C-14 | is_node_voxel_bakeable()実装 | E-01 (317-327行目) | ○ |
| C-15 | GI_MODE_STATIC判定 | E-01 (323-324行目) | ○ |
| C-16 | VoxelGI::bake()実装 | E-01 (430-500行目) | ○ |
| C-17 | get_estimated_cell_size()実装 | E-01 (404-428行目) | ○ |
| C-18 | 分割レベル定数（6,7,8,9） | E-01 (405, 431行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（VoxelGI機能は確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] サイズ最小値1.0の妥当性確認
- [ ] メモリ使用量の見積もり精度確認
- [ ] 2バウンス使用時のパフォーマンス影響確認
